/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;

public class AdviceWithInvalidConfiguredTest
extends ContextTestSupport {
    public void testNoErrorHandler() throws Exception {
        try {
            this.context.getRouteDefinition("route-a").adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() throws Exception {
                    this.errorHandler((ErrorHandlerBuilder)this.loggingErrorHandler());
                    this.interceptSendToEndpoint("direct:bar").skipSendToOriginalEndpoint().throwException((Exception)new IllegalArgumentException("Forced"));
                }
            });
            AdviceWithInvalidConfiguredTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException e) {
            AdviceWithInvalidConfiguredTest.assertEquals((String)"You can not advice with error handlers. Remove the error handlers from the route builder.", (String)e.getMessage());
        }
    }

    public void testNoExtraRoutes() throws Exception {
        try {
            this.context.getRouteDefinition("route-a").adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:foo").to("mock:foo");
                }
            });
            AdviceWithInvalidConfiguredTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException e) {
            AdviceWithInvalidConfiguredTest.assertEquals((String)"You can only advice from a RouteBuilder which has no existing routes. Remove all routes from the route builder.", (String)e.getMessage());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.from("direct:start").routeId("route-a").to("direct:bar");
                this.from("direct:bar").routeId("route-b").to("mock:bar");
            }
        };
    }
}

