/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class AdviceWithOnExceptionAndInterceptTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testFailover() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)((LoadBalanceDefinition)this.from("direct:a").loadBalance().failover(new Class[]{IOException.class}).to("mock:a")).to("mock:b")).end();
            }
        });
        RouteDefinition routeDefinition = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        routeDefinition.adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder());
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(0);
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Intercepted SQL!"});
        this.template.sendBody("direct:a", (Object)"foo");
        this.assertMockEndpointsSatisfied();
    }

    class AdviceWithRouteBuilder
    extends RouteBuilder {
        AdviceWithRouteBuilder() {
        }

        public void configure() {
            ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(SQLException.class).handled(true).transform((Expression)this.constant("Intercepted SQL!"))).log("sending ${body}")).to("mock:b");
            ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:a").skipSendToOriginalEndpoint().log("intercepted message")).bean((Object)new Processor(){

                public void process(Exchange exchange) throws Exception {
                    throw new SQLException();
                }
            });
        }
    }
}

