/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;

public class ChoiceEndOrEndChoiceIssueTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testEndChoiceInvalid() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.header("number").isEqualTo((Object)"one")).to("mock:one")).when(this.header("number").isEqualTo((Object)"two")).to("mock:two")).when(this.header("number").isEqualTo((Object)"three")).to("mock:three")).endChoice().to("mock:finally");
                }
            });
            this.context.start();
            ChoiceEndOrEndChoiceIssueTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            ChoiceEndOrEndChoiceIssueTest.assertEquals((String)"A new choice clause should start with a when() or otherwise(). If you intend to end the entire choice and are using endChoice() then use end() instead.", (String)e.getMessage());
        }
    }

    public void testEndChoiceValid() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.header("number").isEqualTo((Object)"one")).to("mock:one")).when(this.header("number").isEqualTo((Object)"two")).to("mock:two")).when(this.header("number").isEqualTo((Object)"three")).to("mock:three")).end().to("mock:finally");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:one").expectedHeaderReceived("number", (Object)"one");
        this.getMockEndpoint("mock:two").expectedHeaderReceived("number", (Object)"two");
        this.getMockEndpoint("mock:three").expectedHeaderReceived("number", (Object)"three");
        this.getMockEndpoint("mock:finally").expectedBodiesReceived(new Object[]{"1", "2", "3"});
        this.template.sendBodyAndHeader("direct:start", (Object)"1", "number", (Object)"one");
        this.template.sendBodyAndHeader("direct:start", (Object)"2", "number", (Object)"two");
        this.template.sendBodyAndHeader("direct:start", (Object)"3", "number", (Object)"three");
        this.assertMockEndpointsSatisfied();
    }

    public void testEndChoiceEndValid() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.header("number").isEqualTo((Object)"one")).to("mock:one")).when(this.header("number").isEqualTo((Object)"two")).to("mock:two")).when(this.header("number").isEqualTo((Object)"three")).to("mock:three")).endChoice().end().to("mock:finally");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:one").expectedHeaderReceived("number", (Object)"one");
        this.getMockEndpoint("mock:two").expectedHeaderReceived("number", (Object)"two");
        this.getMockEndpoint("mock:three").expectedHeaderReceived("number", (Object)"three");
        this.getMockEndpoint("mock:finally").expectedBodiesReceived(new Object[]{"1", "2", "3"});
        this.template.sendBodyAndHeader("direct:start", (Object)"1", "number", (Object)"one");
        this.template.sendBodyAndHeader("direct:start", (Object)"2", "number", (Object)"two");
        this.template.sendBodyAndHeader("direct:start", (Object)"3", "number", (Object)"three");
        this.assertMockEndpointsSatisfied();
    }
}

