/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class ContextScopedOnExceptionMultipleRouteBuildersTest
extends ContextTestSupport {
    public void testFoo() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:handle-foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:handle-bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        this.assertMockEndpointsSatisfied();
    }

    public void testBar() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:handle-foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:handle-bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.template.sendBody("direct:bar", (Object)"Hello Bar");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.setErrorHandlerBuilder((ErrorHandlerFactory)new DeadLetterChannelBuilder("mock:dead"));
        return context;
    }

    @Override
    protected RouteBuilder[] createRouteBuilders() throws Exception {
        return new RouteBuilder[]{new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).handled(true).to("mock:handle-foo");
                ((RouteDefinition)this.from("direct:foo").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        }, new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).handled(true).to("mock:handle-bar");
                ((RouteDefinition)this.from("direct:bar").to("mock:bar")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        }};
    }
}

