/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;

public class FilterCustomPredicateAsFilterTest
extends ContextTestSupport {
    private MyFiler filter = new MyFiler();

    public void testFilterCustomPredicateAsFilter() throws Exception {
        this.getMockEndpoint("mock:good").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"secret");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        FilterCustomPredicateAsFilterTest.assertEquals((String)"Hello World", (String)this.filter.getBodies().get(0));
        FilterCustomPredicateAsFilterTest.assertEquals((String)"secret", (String)this.filter.getBodies().get(1));
        FilterCustomPredicateAsFilterTest.assertEquals((String)"Bye World", (String)this.filter.getBodies().get(2));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("direct:start").filter((Predicate)FilterCustomPredicateAsFilterTest.this.filter).to("mock:good")).end();
            }
        };
    }

    private static class MyFiler
    implements Predicate {
        private List<String> bodies = new ArrayList<String>();

        private MyFiler() {
        }

        public boolean matches(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            this.bodies.add(body);
            return !"secret".equals(body);
        }

        public List<String> getBodies() {
            return this.bodies;
        }
    }
}

