/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeException;
import org.apache.camel.Expression;
import org.apache.camel.Header;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class RetryRouteScopedUntilRecipientListIssueTest
extends ContextTestSupport {
    protected static AtomicInteger invoked = new AtomicInteger();

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myRetryBean", (Object)new MyRetryBean());
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addEndpoint("fail", (Endpoint)new DefaultEndpoint(){

            public Producer createProducer() throws Exception {
                return new DefaultProducer((Endpoint)this){

                    public void process(Exchange exchange) throws Exception {
                        exchange.setException((Throwable)new IllegalArgumentException("Damn"));
                    }
                };
            }

            public Consumer createConsumer(Processor processor) throws Exception {
                return null;
            }

            protected String createEndpointUri() {
                return "fail";
            }

            public boolean isSingleton() {
                return true;
            }
        });
        context.addEndpoint("not-fail", (Endpoint)new DefaultEndpoint(){

            public Producer createProducer() throws Exception {
                return new DefaultProducer((Endpoint)this){

                    public void process(Exchange exchange) throws Exception {
                    }
                };
            }

            public Consumer createConsumer(Processor processor) throws Exception {
                return null;
            }

            protected String createEndpointUri() {
                return "not-fail";
            }

            public boolean isSingleton() {
                return true;
            }
        });
        return context;
    }

    public void testRetryUntilRecipientListOkOnly() throws Exception {
        invoked.set(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"direct:foo");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        RetryRouteScopedUntilRecipientListIssueTest.assertEquals((int)0, (int)invoked.get());
    }

    public void testRetryUntilRecipientListOkNotFail() throws Exception {
        invoked.set(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"direct:foo,not-fail");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        RetryRouteScopedUntilRecipientListIssueTest.assertEquals((int)0, (int)invoked.get());
    }

    public void testRetryUntilRecipientListFailOnly() throws Exception {
        invoked.set(0);
        NotifyBuilder event = this.event().whenDone(1).create();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"fail");
        this.assertMockEndpointsSatisfied();
        boolean matches = event.matches(10L, TimeUnit.SECONDS);
        RetryRouteScopedUntilRecipientListIssueTest.assertTrue((boolean)matches);
        this.context.stop();
        RetryRouteScopedUntilRecipientListIssueTest.assertEquals((int)3, (int)invoked.get());
    }

    public void testRetryUntilRecipientListFailAndOk() throws Exception {
        invoked.set(0);
        NotifyBuilder event = this.event().whenDone(1).create();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(0);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"fail,direct:foo");
        this.assertMockEndpointsSatisfied();
        boolean matches = event.matches(10L, TimeUnit.SECONDS);
        RetryRouteScopedUntilRecipientListIssueTest.assertTrue((boolean)matches);
        this.context.stop();
        RetryRouteScopedUntilRecipientListIssueTest.assertEquals((int)3, (int)invoked.get());
    }

    public void testRetryUntilRecipientListOkAndFail() throws Exception {
        invoked.set(0);
        NotifyBuilder event = this.event().whenFailed(1).create();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"direct:foo,fail");
        this.assertMockEndpointsSatisfied();
        boolean matches = event.matches(10L, TimeUnit.SECONDS);
        RetryRouteScopedUntilRecipientListIssueTest.assertTrue((boolean)matches);
        this.context.stop();
        RetryRouteScopedUntilRecipientListIssueTest.assertEquals((int)3, (int)invoked.get());
    }

    public void testRetryUntilRecipientNotFail() throws Exception {
        invoked.set(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"not-fail");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        RetryRouteScopedUntilRecipientListIssueTest.assertEquals((int)0, (int)invoked.get());
    }

    public void testRetryUntilRecipientFailAndNotFail() throws Exception {
        invoked.set(0);
        NotifyBuilder event = this.event().whenDone(1).create();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(0);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"fail,not-fail");
        this.assertMockEndpointsSatisfied();
        boolean matches = event.matches(10L, TimeUnit.SECONDS);
        RetryRouteScopedUntilRecipientListIssueTest.assertTrue((boolean)matches);
        this.context.stop();
        RetryRouteScopedUntilRecipientListIssueTest.assertEquals((int)3, (int)invoked.get());
    }

    public void testRetryUntilRecipientNotFailAndFail() throws Exception {
        invoked.set(0);
        NotifyBuilder event = this.event().whenDone(1).create();
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(0);
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "recipientListHeader", (Object)"not-fail,fail");
        this.assertMockEndpointsSatisfied();
        boolean matches = event.matches(10L, TimeUnit.SECONDS);
        RetryRouteScopedUntilRecipientListIssueTest.assertTrue((boolean)matches);
        this.context.stop();
        RetryRouteScopedUntilRecipientListIssueTest.assertEquals((int)3, (int)invoked.get());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:start").onException(Exception.class).retryWhile((Predicate)this.method("myRetryBean")).end().recipientList((Expression)this.header("recipientListHeader")).to("mock:result");
                ((RouteDefinition)this.from("direct:foo").to("log:foo")).to("mock:foo");
            }
        };
    }

    public class MyRetryBean {
        public boolean retry(@Header(value="CamelRedeliveryCounter") Integer counter, @Body String body, @ExchangeException Exception causedBy) {
            invoked.incrementAndGet();
            return counter < 3;
        }
    }
}

