/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;

public class RetryWhilePredicateExpressionIssueTest
extends ContextTestSupport {
    public void testRetryWhilePredicate() throws Exception {
        MyCoolDude dude = new MyCoolDude();
        this.template.sendBodyAndHeader("direct:start", (Object)dude, "foo", (Object)123);
        RetryWhilePredicateExpressionIssueTest.assertEquals((int)4, (int)dude.getCounter());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).handled(true).retryWhile(new Predicate(){

                    public boolean matches(Exchange exchange) {
                        Predicate predicate = PredicateBuilder.and((Predicate)this.simple("${body.areWeCool} == 'no'"), (Predicate)PredicateBuilder.isNotNull((Expression)this.header("foo")));
                        boolean answer = predicate.matches(exchange);
                        return answer;
                    }
                });
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }

    public static class MyCoolDude {
        private int counter;

        public String areWeCool() {
            if (this.counter++ < 3) {
                return "no";
            }
            return "yes";
        }

        public int getCounter() {
            return this.counter;
        }
    }
}

