/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.ServiceSupport;

public class ServicePoolAwareLeakyTest
extends ContextTestSupport {
    private static final String LEAKY_SIEVE_STABLE = "leaky://sieve-stable";
    private static final String LEAKY_SIEVE_TRANSIENT = "leaky://sieve-transient";

    @Override
    protected boolean useJmx() {
        return true;
    }

    public boolean isFailFast() {
        return false;
    }

    public boolean isVerifyProducerServicePoolRemainsStarted() {
        return false;
    }

    public void testForMemoryLeak() throws Exception {
        this.registerLeakyComponent();
        final HashMap references = new HashMap();
        this.context.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onServiceAdd(CamelContext context, Service service, Route route) {
                if (service instanceof LeakySieveProducer) {
                    String key = ((LeakySieveProducer)service).getEndpoint().getEndpointKey();
                    AtomicLong num = (AtomicLong)references.get(key);
                    if (num == null) {
                        num = new AtomicLong();
                        references.put(key, num);
                    }
                    num.incrementAndGet();
                }
            }

            public void onServiceRemove(CamelContext context, Service service, Route route) {
                if (service instanceof LeakySieveProducer) {
                    String key = ((LeakySieveProducer)service).getEndpoint().getEndpointKey();
                    AtomicLong num = (AtomicLong)references.get(key);
                    if (num == null) {
                        num = new AtomicLong();
                        references.put(key, num);
                    }
                    num.decrementAndGet();
                }
            }
        });
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:sieve-transient").id("sieve-transient")).to(ServicePoolAwareLeakyTest.LEAKY_SIEVE_TRANSIENT);
                ((RouteDefinition)this.from("direct:sieve-stable").id("sieve-stable")).to(ServicePoolAwareLeakyTest.LEAKY_SIEVE_STABLE);
            }
        });
        this.context.start();
        for (int i = 0; i < 1000; ++i) {
            ServiceSupport service = (ServiceSupport)this.context.getProducerServicePool();
            ServicePoolAwareLeakyTest.assertEquals((Object)ServiceStatus.Started, (Object)service.getStatus());
            if (this.isFailFast()) {
                ServicePoolAwareLeakyTest.assertEquals((int)2, (int)this.context.getProducerServicePool().size());
                ServicePoolAwareLeakyTest.assertEquals((long)1L, (long)((AtomicLong)references.get(LEAKY_SIEVE_TRANSIENT)).get());
                ServicePoolAwareLeakyTest.assertEquals((long)1L, (long)((AtomicLong)references.get(LEAKY_SIEVE_STABLE)).get());
            }
            this.context.stopRoute("sieve-transient");
            if (this.isFailFast()) {
                ServicePoolAwareLeakyTest.assertEquals((String)"Expected no service references to remain", (Object)0, references.get(LEAKY_SIEVE_TRANSIENT));
            }
            if (this.isFailFast()) {
                if (this.isVerifyProducerServicePoolRemainsStarted()) {
                    ServicePoolAwareLeakyTest.assertEquals((Object)ServiceStatus.Started, (Object)service.getStatus());
                }
                ServicePoolAwareLeakyTest.assertEquals((String)"Expected one stable producer to remain pooled", (int)1, (int)this.context.getProducerServicePool().size());
                ServicePoolAwareLeakyTest.assertEquals((String)"Expected one stable producer to remain as service", (long)1L, (long)((AtomicLong)references.get(LEAKY_SIEVE_STABLE)).get());
            }
            this.sendBody("direct:sieve-stable", "");
            if (this.isFailFast()) {
                if (this.isVerifyProducerServicePoolRemainsStarted()) {
                    ServicePoolAwareLeakyTest.assertEquals((Object)ServiceStatus.Started, (Object)service.getStatus());
                }
                ServicePoolAwareLeakyTest.assertEquals((String)"Expected only stable producer in pool", (int)1, (int)this.context.getProducerServicePool().size());
                ServicePoolAwareLeakyTest.assertEquals((String)"Expected no references to transient producer", (long)0L, (long)((AtomicLong)references.get(LEAKY_SIEVE_TRANSIENT)).get());
                ServicePoolAwareLeakyTest.assertEquals((String)"Expected reference to stable producer", (long)1L, (long)((AtomicLong)references.get(LEAKY_SIEVE_STABLE)).get());
            }
            this.context.startRoute("sieve-transient");
            ServicePoolAwareLeakyTest.assertEquals((Object)ServiceStatus.Started, (Object)service.getStatus());
            if (!this.isFailFast()) continue;
            ServicePoolAwareLeakyTest.assertEquals((String)"Expected both producers in pool", (int)2, (int)this.context.getProducerServicePool().size());
            ServicePoolAwareLeakyTest.assertEquals((String)"Expected one transient producer as service", (long)1L, (long)((AtomicLong)references.get(LEAKY_SIEVE_TRANSIENT)).get());
            ServicePoolAwareLeakyTest.assertEquals((String)"Expected one stable producer as service", (long)1L, (long)((AtomicLong)references.get(LEAKY_SIEVE_STABLE)).get());
        }
        if (!this.isFailFast()) {
            ServicePoolAwareLeakyTest.assertEquals((String)"Expected both producers in pool", (int)2, (int)this.context.getProducerServicePool().size());
            ServicePoolAwareLeakyTest.assertEquals((String)"Expected one transient producer as service", (long)1L, (long)((AtomicLong)references.get(LEAKY_SIEVE_TRANSIENT)).get());
            ServicePoolAwareLeakyTest.assertEquals((String)"Expected one stable producer as service", (long)1L, (long)((AtomicLong)references.get(LEAKY_SIEVE_STABLE)).get());
        }
    }

    private void registerLeakyComponent() {
        this.context.addComponent("leaky", (Component)new LeakySieveComponent());
    }

    private static class LeakySieveProducer
    extends DefaultProducer
    implements ServicePoolAware {
        public LeakySieveProducer(Endpoint endpoint) {
            super(endpoint);
        }

        public void process(Exchange exchange) throws Exception {
        }
    }

    private static class LeakySieveEndpoint
    extends DefaultEndpoint {
        private final String uri;

        public LeakySieveEndpoint(String uri) {
            this.uri = uri;
        }

        public Producer createProducer() throws Exception {
            return new LeakySieveProducer((Endpoint)this);
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            throw new UnsupportedOperationException();
        }

        public boolean isSingleton() {
            return true;
        }

        protected String createEndpointUri() {
            return this.uri;
        }
    }

    private static class LeakySieveComponent
    extends DefaultComponent {
        private LeakySieveComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            return new LeakySieveEndpoint(uri);
        }
    }
}

