/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import junit.framework.TestCase;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;

public class StopRouteFromRouteTest
extends TestCase {
    public void testStopRouteFromRoute() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)this.createMyRoutes());
        context.start();
        StopRouteFromRouteTest.assertTrue((String)"Route myRoute should be started", (boolean)context.getRouteStatus("myRoute").isStarted());
        StopRouteFromRouteTest.assertTrue((String)"Route bar should be started", (boolean)context.getRouteStatus("bar").isStarted());
        MockEndpoint start = (MockEndpoint)context.getEndpoint("mock:start", MockEndpoint.class);
        start.expectedMessageCount(1);
        MockEndpoint done = (MockEndpoint)context.getEndpoint("mock:done", MockEndpoint.class);
        done.expectedMessageCount(1);
        ProducerTemplate template = context.createProducerTemplate();
        template.sendBody("direct:start", (Object)"Hello Camel");
        Thread.sleep(1500L);
        StopRouteFromRouteTest.assertTrue((String)"Route myRoute should be stopped", (boolean)context.getRouteStatus("myRoute").isStopped());
        StopRouteFromRouteTest.assertTrue((String)"Route bar should be started", (boolean)context.getRouteStatus("bar").isStarted());
        context.stop();
        start.assertIsSatisfied();
        done.assertIsSatisfied();
    }

    public RouteBuilder createMyRoutes() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("myRoute").to("mock:start")).process(new Processor(){
                    Thread stop;

                    public void process(final Exchange exchange) throws Exception {
                        if (this.stop == null) {
                            this.stop = new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        exchange.getContext().stopRoute("myRoute");
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            };
                        }
                        this.stop.start();
                    }
                })).to("mock:done");
                this.from("direct:bar").routeId("bar").to("mock:bar");
            }
        };
    }
}

