/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.util.FileUtil;

public class FileLanguageTest
extends LanguageTestSupport {
    private File file;

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("generator", (Object)new MyFileNameGenerator());
        return jndi;
    }

    @Override
    protected String getLanguageName() {
        return "file";
    }

    public void testConstantExpression() throws Exception {
        this.assertExpression("MyBigFile.txt", "MyBigFile.txt");
    }

    public void testMessageId() throws Exception {
        this.assertExpression("${id}", this.exchange.getIn().getMessageId());
        this.assertExpression("${id}.bak", this.exchange.getIn().getMessageId() + ".bak");
    }

    public void testInvalidSyntax() throws Exception {
        this.assertExpression("${file:onlyname}", this.file.getName());
        try {
            this.assertExpression("${file:onlyName}", this.file.getName());
            FileLanguageTest.fail((String)"Should have thrown exception");
        }
        catch (ExpressionIllegalSyntaxException e) {
            FileLanguageTest.assertTrue((boolean)e.getMessage().startsWith("Unknown file language syntax: onlyName at location 0"));
        }
    }

    public void testFile() throws Exception {
        this.assertExpression("${file:ext}", "txt");
        this.assertExpression("${file:name.ext}", "txt");
        this.assertExpression("${file:name.ext.single}", "txt");
        this.assertExpression("${file:name}", "test" + File.separator + this.file.getName());
        this.assertExpression("${file:name.noext}", "test" + File.separator + "hello");
        this.assertExpression("${file:name.noext.single}", "test" + File.separator + "hello");
        this.assertExpression("${file:onlyname}", this.file.getName());
        this.assertExpression("${file:onlyname.noext}", "hello");
        this.assertExpression("${file:onlyname.noext.single}", "hello");
        this.assertExpression("${file:parent}", this.file.getParent());
        this.assertExpression("${file:path}", this.file.getPath());
        this.assertExpression("${file:absolute}", FileUtil.isAbsolute((File)this.file));
        this.assertExpression("${file:absolute.path}", this.file.getAbsolutePath());
        this.assertExpression("${file:length}", this.file.length());
        this.assertExpression("${file:size}", this.file.length());
        Long modified = (Long)SimpleLanguage.simple((String)"${file:modified}").evaluate(this.exchange, Long.class);
        FileLanguageTest.assertEquals((long)this.file.lastModified(), (long)modified);
    }

    public void testFileUsingAlternativeStartToken() throws Exception {
        this.assertExpression("$simple{file:ext}", "txt");
        this.assertExpression("$simple{file:name.ext}", "txt");
        this.assertExpression("$simple{file:name}", "test" + File.separator + this.file.getName());
        this.assertExpression("$simple{file:name.noext}", "test" + File.separator + "hello");
        this.assertExpression("$simple{file:onlyname}", this.file.getName());
        this.assertExpression("$simple{file:onlyname.noext}", "hello");
        this.assertExpression("$simple{file:parent}", this.file.getParent());
        this.assertExpression("$simple{file:path}", this.file.getPath());
        this.assertExpression("$simple{file:absolute}", FileUtil.isAbsolute((File)this.file));
        this.assertExpression("$simple{file:absolute.path}", this.file.getAbsolutePath());
        this.assertExpression("$simple{file:length}", this.file.length());
        this.assertExpression("$simple{file:size}", this.file.length());
        long modified = (Long)SimpleLanguage.simple((String)"${file:modified}").evaluate(this.exchange, Long.TYPE);
        FileLanguageTest.assertEquals((long)this.file.lastModified(), (long)modified);
    }

    public void testDate() throws Exception {
        String now = new SimpleDateFormat("yyyyMMdd").format(new Date());
        this.assertExpression("backup-${date:now:yyyyMMdd}", "backup-" + now);
        String expected = new SimpleDateFormat("yyyyMMdd").format(new Date(this.file.lastModified()));
        this.assertExpression("backup-${date:file:yyyyMMdd}", "backup-" + expected);
        this.assertExpression("backup-${date:header.birthday:yyyyMMdd}", "backup-19740420");
        this.assertExpression("hello-${date:out.header.special:yyyyMMdd}", "hello-20080808");
        try {
            this.assertExpression("nodate-${date:header.xxx:yyyyMMdd}", null);
            FileLanguageTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDateUsingAlternativeStartToken() throws Exception {
        String now = new SimpleDateFormat("yyyyMMdd").format(new Date());
        this.assertExpression("backup-$simple{date:now:yyyyMMdd}", "backup-" + now);
        String expected = new SimpleDateFormat("yyyyMMdd").format(new Date(this.file.lastModified()));
        this.assertExpression("backup-$simple{date:file:yyyyMMdd}", "backup-" + expected);
        this.assertExpression("backup-$simple{date:header.birthday:yyyyMMdd}", "backup-19740420");
        this.assertExpression("hello-$simple{date:out.header.special:yyyyMMdd}", "hello-20080808");
        try {
            this.assertExpression("nodate-$simple{date:header.xxx:yyyyMMdd}", null);
            FileLanguageTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSimpleAndFile() throws Exception {
        this.assertExpression("backup-${in.header.foo}-${file:name.noext}.bak", "backup-abc-test" + File.separator + "hello.bak");
        this.assertExpression("backup-${in.header.foo}-${file:onlyname.noext}.bak", "backup-abc-hello.bak");
    }

    public void testSimpleAndFileAndBean() throws Exception {
        this.assertExpression("backup-${in.header.foo}-${bean:generator}-${file:name.noext}.bak", "backup-abc-generatorbybean-test" + File.separator + "hello.bak");
        this.assertExpression("backup-${in.header.foo}-${bean:generator}-${file:onlyname.noext}.bak", "backup-abc-generatorbybean-hello.bak");
    }

    public void testBean() throws Exception {
        this.assertExpression("backup-${bean:generator}.txt", "backup-generatorbybean.txt");
        this.assertExpression("backup-${bean:generator.generateFilename}.txt", "backup-generatorbybean.txt");
    }

    public void testNoEscapeAllowed() throws Exception {
        this.exchange.getIn().setHeader("CamelFileName", (Object)"hello.txt");
        this.assertExpression("target\\newdir\\onwindows\\${file:name}", "target\\newdir\\onwindows\\hello.txt");
    }

    public void testFileNameDoubleExtension() throws Exception {
        this.file = new File("target/filelanguage/test/bigfile.tar.gz");
        String uri = "file://target/filelanguage?fileExist=Override";
        GenericFile gf = FileConsumer.asGenericFile((String)"target/filelanguage", (File)this.file, null);
        FileEndpoint endpoint = this.getMandatoryEndpoint(uri, FileEndpoint.class);
        Exchange answer = endpoint.createExchange(gf);
        endpoint.configureMessage(gf, answer.getIn());
        FileLanguageTest.assertEquals((String)"bigfile.tar.gz", (String)this.file.getName());
        this.assertExpression(answer, "${file:onlyname}", (Object)"bigfile.tar.gz");
        this.assertExpression(answer, "${file:ext}", (Object)"tar.gz");
    }

    @Override
    public Exchange createExchange() {
        String uri = "file://target/filelanguage?fileExist=Override";
        this.template.sendBodyAndHeader(uri, (Object)"Hello World", "CamelFileName", (Object)"test/hello.txt");
        this.file = new File("target/filelanguage/test/hello.txt");
        GenericFile gf = FileConsumer.asGenericFile((String)"target/filelanguage", (File)this.file, null);
        FileEndpoint endpoint = this.getMandatoryEndpoint(uri, FileEndpoint.class);
        Exchange answer = endpoint.createExchange(gf);
        endpoint.configureMessage(gf, answer.getIn());
        Calendar cal = Calendar.getInstance();
        cal.set(1974, 3, 20);
        answer.getIn().setHeader("birthday", (Object)cal.getTime());
        cal.set(2008, 7, 8);
        answer.getOut().setHeader("special", (Object)cal.getTime());
        return answer;
    }

    public void testIllegalSyntax() throws Exception {
        try {
            this.assertExpression("${file.name}", "");
            FileLanguageTest.fail((String)"Should have thrown an exception");
        }
        catch (ExpressionIllegalSyntaxException e) {
            FileLanguageTest.assertTrue((boolean)e.getMessage().startsWith("Unknown function: file.name at location 0"));
        }
        try {
            this.assertExpression("hey ${xxx} how are you?", "");
            FileLanguageTest.fail((String)"Should have thrown an exception");
        }
        catch (ExpressionIllegalSyntaxException e) {
            FileLanguageTest.assertTrue((boolean)e.getMessage().startsWith("Unknown function: xxx at location 4"));
        }
        try {
            this.assertExpression("${xxx}", "");
            FileLanguageTest.fail((String)"Should have thrown an exception");
        }
        catch (ExpressionIllegalSyntaxException e) {
            FileLanguageTest.assertTrue((boolean)e.getMessage().startsWith("Unknown function: xxx at location 0"));
        }
    }

    public void testConstantFilename() throws Exception {
        this.assertExpression("hello.txt", "hello.txt");
    }

    public class MyFileNameGenerator {
        public String generateFilename(Exchange exchange) {
            return "generatorbybean";
        }
    }
}

