/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.language.simple.SimplePredicateParser;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;

public class SimpleParserPredicateInvalidTest
extends ExchangeTestSupport {
    public void testSimpleEqFunctionInvalid() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        SimplePredicateParser parser = new SimplePredicateParser("${header.high} == abc", true);
        try {
            parser.parsePredicate();
            SimpleParserPredicateInvalidTest.fail((String)"Should thrown exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleParserPredicateInvalidTest.assertEquals((int)18, (int)e.getIndex());
        }
    }

    public void testSimpleInvalidSymbol() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        SimplePredicateParser parser = new SimplePredicateParser("${header.high} = true", true);
        try {
            parser.parsePredicate();
            SimpleParserPredicateInvalidTest.fail((String)"Should thrown exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleParserPredicateInvalidTest.assertEquals((int)15, (int)e.getIndex());
        }
    }

    public void testSimpleUnevenSingleQuote() throws Exception {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser("${body} == 'foo", true);
        try {
            parser.parsePredicate();
            SimpleParserPredicateInvalidTest.fail((String)"Should thrown exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleParserPredicateInvalidTest.assertEquals((int)14, (int)e.getIndex());
        }
    }

    public void testSimpleUnevenDoubleQuote() throws Exception {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser("${body} == \"foo", true);
        try {
            parser.parsePredicate();
            SimpleParserPredicateInvalidTest.fail((String)"Should thrown exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleParserPredicateInvalidTest.assertEquals((int)14, (int)e.getIndex());
        }
    }

    public void testSimpleTwoAnd() throws Exception {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser("${body} == 'foo' && && ${header} == 123", true);
        try {
            parser.parsePredicate();
            SimpleParserPredicateInvalidTest.fail((String)"Should thrown exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleParserPredicateInvalidTest.assertEquals((int)20, (int)e.getIndex());
        }
    }

    public void testSimpleTwoOr() throws Exception {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser("${body} == 'foo' || || ${header} == 123", true);
        try {
            parser.parsePredicate();
            SimpleParserPredicateInvalidTest.fail((String)"Should thrown exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleParserPredicateInvalidTest.assertEquals((int)20, (int)e.getIndex());
        }
    }

    public void testSimpleTwoEq() throws Exception {
        this.exchange.getIn().setBody((Object)"foo");
        SimplePredicateParser parser = new SimplePredicateParser("${body} == == 'foo'", true);
        try {
            parser.parsePredicate();
            SimpleParserPredicateInvalidTest.fail((String)"Should thrown exception");
        }
        catch (SimpleIllegalSyntaxException e) {
            SimpleParserPredicateInvalidTest.assertEquals((int)11, (int)e.getIndex());
        }
    }
}

