/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.tokenizer;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.SplitDefinition;

public class XMLTokenizeWrapLanguageTest
extends ContextTestSupport {
    public void testSendClosedTagMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='a' anotherAttr='a'></c:child></c:parent>", "<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='b' anotherAttr='b'></c:child></c:parent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='a' anotherAttr='a'></c:child><c:child some_attr='b' anotherAttr='b'></c:child></c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendClosedTagWithLineBreaksMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?>\n<c:parent xmlns:c='urn:c'>\n<c:child some_attr='a' anotherAttr='a'>\n</c:child></c:parent>", "<?xml version='1.0' encoding='UTF-8'?>\n<c:parent xmlns:c='urn:c'>\n<c:child some_attr='b' anotherAttr='b'>\n</c:child></c:parent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?>\n<c:parent xmlns:c='urn:c'>\n<c:child some_attr='a' anotherAttr='a'>\n</c:child>\n<c:child some_attr='b' anotherAttr='b'>\n</c:child>\n</c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendSelfClosingTagMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='a' anotherAttr='a' /></c:parent>", "<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='b' anotherAttr='b' /></c:parent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='a' anotherAttr='a' /><c:child some_attr='b' anotherAttr='b' /></c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendMixedClosingTagMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='a' anotherAttr='a'>ha</c:child></c:parent>", "<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='b' anotherAttr='b' /></c:parent>", "<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='c'></c:child></c:parent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='a' anotherAttr='a'>ha</c:child><c:child some_attr='b' anotherAttr='b' /><c:child some_attr='c'></c:child></c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendMixedClosingTagInsideMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<c:parent xmlns:c='urn:c'><c:child name='child1'><grandchild name='grandchild1'/> <grandchild name='grandchild2'/></c:child></c:parent>", "<c:parent xmlns:c='urn:c'><c:child name='child2'><grandchild name='grandchild1'></grandchild><grandchild name='grandchild2'></grandchild></c:child></c:parent>"});
        this.template.sendBody("direct:start", (Object)"<c:parent xmlns:c='urn:c'><c:child name='child1'><grandchild name='grandchild1'/> <grandchild name='grandchild2'/></c:child><c:child name='child2'><grandchild name='grandchild1'></grandchild><grandchild name='grandchild2'></grandchild></c:child></c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendNamespacedChildMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child xmlns:c='urn:c' some_attr='a' anotherAttr='a'></c:child></c:parent>", "<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child xmlns:c='urn:c' some_attr='b' anotherAttr='b' /></c:parent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child xmlns:c='urn:c' some_attr='a' anotherAttr='a'></c:child><c:child xmlns:c='urn:c' some_attr='b' anotherAttr='b' /></c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendNamespacedParentMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='a' anotherAttr='a'></c:child></c:parent>", "<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='b' anotherAttr='b'/></c:parent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='a' anotherAttr='a'></c:child><c:child some_attr='b' anotherAttr='b'/></c:parent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendMoreParentsMessageToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?><g:greatgrandparent xmlns:g='urn:g'><grandparent><uncle/><aunt>emma</aunt><c:parent xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='a' anotherAttr='a'></c:child></c:parent></grandparent></g:greatgrandparent>", "<?xml version='1.0' encoding='UTF-8'?><g:greatgrandparent xmlns:g='urn:g'><grandparent><uncle/><aunt>emma</aunt><c:parent xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='b' anotherAttr='b'/></c:parent></grandparent></g:greatgrandparent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><g:greatgrandparent xmlns:g='urn:g'><grandparent><uncle/><aunt>emma</aunt><c:parent xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='a' anotherAttr='a'></c:child><c:child some_attr='b' anotherAttr='b'/></c:parent></grandparent></g:greatgrandparent>");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendParentMessagesWithDifferentAttributesToTokenize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"<?xml version='1.0' encoding='UTF-8'?><g:grandparent xmlns:g='urn:g'><c:parent name='e' xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='a' anotherAttr='a'></c:child></c:parent></g:grandparent>", "<?xml version='1.0' encoding='UTF-8'?><g:grandparent xmlns:g='urn:g'><c:parent name='f' xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='b' anotherAttr='b'/></c:parent></g:grandparent>"});
        this.template.sendBody("direct:start", (Object)"<?xml version='1.0' encoding='UTF-8'?><g:grandparent xmlns:g='urn:g'><c:parent name='e' xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='a' anotherAttr='a'></c:child></c:parent><c:parent name='f' xmlns:c='urn:c' xmlns:d=\"urn:d\"><c:child some_attr='b' anotherAttr='b'/></c:parent></g:grandparent>");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){
            Namespaces ns = new Namespaces("C", "urn:c");

            public void configure() {
                ((ExpressionNode)((SplitDefinition)this.from("direct:start").split().xtokenize("//C:child", 'w', this.ns)).to("mock:result")).end();
            }
        };
    }
}

