/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.event.CamelContextResumedEvent;
import org.apache.camel.management.event.CamelContextResumingEvent;
import org.apache.camel.management.event.CamelContextStartedEvent;
import org.apache.camel.management.event.CamelContextStartingEvent;
import org.apache.camel.management.event.CamelContextStoppedEvent;
import org.apache.camel.management.event.CamelContextStoppingEvent;
import org.apache.camel.management.event.CamelContextSuspendedEvent;
import org.apache.camel.management.event.CamelContextSuspendingEvent;
import org.apache.camel.management.event.ExchangeCompletedEvent;
import org.apache.camel.management.event.ExchangeCreatedEvent;
import org.apache.camel.management.event.ExchangeFailedEvent;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.management.event.RouteAddedEvent;
import org.apache.camel.management.event.RouteRemovedEvent;
import org.apache.camel.management.event.RouteStartedEvent;
import org.apache.camel.management.event.RouteStoppedEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.EventNotifierSupport;

public class EventNotifierEventsTest
extends ContextTestSupport {
    private static List<EventObject> events = new ArrayList<EventObject>();

    @Override
    public void setUp() throws Exception {
        events.clear();
        super.setUp();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(EventObject event) throws Exception {
                events.add(event);
            }

            public boolean isEnabled(EventObject event) {
                return true;
            }

            protected void doStart() throws Exception {
            }

            protected void doStop() throws Exception {
            }
        });
        return context;
    }

    public void testExchangeDone() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        EventNotifierEventsTest.assertEquals((int)14, (int)events.size());
        EventNotifierEventsTest.assertIsInstanceOf(CamelContextStartingEvent.class, events.get(0));
        EventNotifierEventsTest.assertIsInstanceOf(RouteAddedEvent.class, events.get(1));
        EventNotifierEventsTest.assertIsInstanceOf(RouteAddedEvent.class, events.get(2));
        EventNotifierEventsTest.assertIsInstanceOf(RouteStartedEvent.class, events.get(3));
        EventNotifierEventsTest.assertIsInstanceOf(RouteStartedEvent.class, events.get(4));
        EventNotifierEventsTest.assertIsInstanceOf(CamelContextStartedEvent.class, events.get(5));
        EventNotifierEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, events.get(7));
        EventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(9));
        EventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(11));
        EventNotifierEventsTest.assertIsInstanceOf(ExchangeCompletedEvent.class, events.get(12));
        EventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(13));
        this.context.stop();
        EventNotifierEventsTest.assertEquals((int)20, (int)events.size());
        EventNotifierEventsTest.assertIsInstanceOf(CamelContextStoppingEvent.class, events.get(14));
        EventNotifierEventsTest.assertIsInstanceOf(RouteStoppedEvent.class, events.get(15));
        EventNotifierEventsTest.assertIsInstanceOf(RouteRemovedEvent.class, events.get(16));
        EventNotifierEventsTest.assertIsInstanceOf(RouteStoppedEvent.class, events.get(17));
        EventNotifierEventsTest.assertIsInstanceOf(RouteRemovedEvent.class, events.get(18));
        EventNotifierEventsTest.assertIsInstanceOf(CamelContextStoppedEvent.class, events.get(19));
    }

    public void testExchangeFailed() throws Exception {
        try {
            this.template.sendBody("direct:fail", (Object)"Hello World");
            EventNotifierEventsTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            EventNotifierEventsTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        }
        EventNotifierEventsTest.assertEquals((int)10, (int)events.size());
        EventNotifierEventsTest.assertIsInstanceOf(CamelContextStartingEvent.class, events.get(0));
        EventNotifierEventsTest.assertIsInstanceOf(RouteAddedEvent.class, events.get(1));
        EventNotifierEventsTest.assertIsInstanceOf(RouteAddedEvent.class, events.get(2));
        EventNotifierEventsTest.assertIsInstanceOf(RouteStartedEvent.class, events.get(3));
        EventNotifierEventsTest.assertIsInstanceOf(RouteStartedEvent.class, events.get(4));
        EventNotifierEventsTest.assertIsInstanceOf(CamelContextStartedEvent.class, events.get(5));
        EventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(6));
        EventNotifierEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, events.get(7));
        EventNotifierEventsTest.assertIsInstanceOf(ExchangeFailedEvent.class, events.get(8));
        EventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(9));
        this.context.stop();
        EventNotifierEventsTest.assertEquals((int)16, (int)events.size());
        EventNotifierEventsTest.assertIsInstanceOf(CamelContextStoppingEvent.class, events.get(10));
        EventNotifierEventsTest.assertIsInstanceOf(RouteStoppedEvent.class, events.get(11));
        EventNotifierEventsTest.assertIsInstanceOf(RouteRemovedEvent.class, events.get(12));
        EventNotifierEventsTest.assertIsInstanceOf(RouteStoppedEvent.class, events.get(13));
        EventNotifierEventsTest.assertIsInstanceOf(RouteRemovedEvent.class, events.get(14));
        EventNotifierEventsTest.assertIsInstanceOf(CamelContextStoppedEvent.class, events.get(15));
    }

    public void testSuspendResume() throws Exception {
        EventNotifierEventsTest.assertEquals((int)6, (int)events.size());
        EventNotifierEventsTest.assertIsInstanceOf(CamelContextStartingEvent.class, events.get(0));
        EventNotifierEventsTest.assertIsInstanceOf(RouteAddedEvent.class, events.get(1));
        EventNotifierEventsTest.assertIsInstanceOf(RouteAddedEvent.class, events.get(2));
        EventNotifierEventsTest.assertIsInstanceOf(RouteStartedEvent.class, events.get(3));
        EventNotifierEventsTest.assertIsInstanceOf(RouteStartedEvent.class, events.get(4));
        EventNotifierEventsTest.assertIsInstanceOf(CamelContextStartedEvent.class, events.get(5));
        this.context.suspend();
        EventNotifierEventsTest.assertEquals((int)8, (int)events.size());
        EventNotifierEventsTest.assertIsInstanceOf(CamelContextSuspendingEvent.class, events.get(6));
        EventNotifierEventsTest.assertIsInstanceOf(CamelContextSuspendedEvent.class, events.get(7));
        this.context.resume();
        EventNotifierEventsTest.assertEquals((int)10, (int)events.size());
        EventNotifierEventsTest.assertIsInstanceOf(CamelContextResumingEvent.class, events.get(8));
        EventNotifierEventsTest.assertIsInstanceOf(CamelContextResumedEvent.class, events.get(9));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
                this.from("direct:fail").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

