/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedBrowsableEndpointTest
extends ManagementTestSupport {
    public void testBrowseableEndpoint() throws Exception {
        if (ManagedBrowsableEndpointTest.isPlatform("aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://result\"");
        String uri = (String)mbeanServer.getAttribute(name, "EndpointUri");
        ManagedBrowsableEndpointTest.assertEquals((String)"mock://result", (String)uri);
        Long size = (Long)mbeanServer.invoke(name, "queueSize", null, null);
        ManagedBrowsableEndpointTest.assertEquals((long)2L, (long)size);
        String out = (String)mbeanServer.invoke(name, "browseExchange", new Object[]{0}, new String[]{"java.lang.Integer"});
        ManagedBrowsableEndpointTest.assertNotNull((Object)out);
        ManagedBrowsableEndpointTest.assertTrue((boolean)out.contains("Hello World"));
        out = (String)mbeanServer.invoke(name, "browseExchange", new Object[]{1}, new String[]{"java.lang.Integer"});
        ManagedBrowsableEndpointTest.assertNotNull((Object)out);
        ManagedBrowsableEndpointTest.assertTrue((boolean)out.contains("Bye World"));
        out = (String)mbeanServer.invoke(name, "browseMessageBody", new Object[]{1}, new String[]{"java.lang.Integer"});
        ManagedBrowsableEndpointTest.assertNotNull((Object)out);
        ManagedBrowsableEndpointTest.assertEquals((String)"Bye World", (String)out);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

