/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;

public class ManagedCustomLoadBalancerTest
extends ManagementTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBalancer", (Object)new MyLoadBalancer());
        return jndi;
    }

    public void testManageCustomLoadBalancer() throws Exception {
        if (ManagedCustomLoadBalancerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedCustomLoadBalancerTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedCustomLoadBalancerTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedCustomLoadBalancerTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        Integer size = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedCustomLoadBalancerTest.assertEquals((int)2, (int)size);
        String ref = (String)mbeanServer.getAttribute(on, "Ref");
        ManagedCustomLoadBalancerTest.assertEquals((String)"myBalancer", (String)ref);
        String name = (String)mbeanServer.getAttribute(on, "LoadBalancerClassName");
        ManagedCustomLoadBalancerTest.assertEquals((String)MyLoadBalancer.class.getName(), (String)name);
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedCustomLoadBalancerTest.assertNotNull((Object)data);
        ManagedCustomLoadBalancerTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedCustomLoadBalancerTest.assertNotNull((Object)data);
        ManagedCustomLoadBalancerTest.assertEquals((int)5, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedCustomLoadBalancerTest.assertNotNull((Object)json);
        ManagedCustomLoadBalancerTest.assertTrue((boolean)json.contains("\"description\": \"Balances message processing among a number of nodes"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)this.from("direct:start").loadBalance().custom("myBalancer").id("mysend")).to(new String[]{"mock:foo", "mock:bar"});
            }
        };
    }

    public static class MyLoadBalancer
    extends LoadBalancerSupport {
        public boolean process(Exchange exchange, AsyncCallback callback) {
            String body = (String)exchange.getIn().getBody(String.class);
            try {
                if ("x".equals(body)) {
                    ((Processor)this.getProcessors().get(0)).process(exchange);
                } else if ("y".equals(body)) {
                    ((Processor)this.getProcessors().get(1)).process(exchange);
                } else {
                    ((Processor)this.getProcessors().get(2)).process(exchange);
                }
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
    }
}

