/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.ServiceSupport;

public class ManagedCustomProcessorTest
extends ManagementTestSupport {
    public void testManageCustomProcessor() throws Exception {
        if (ManagedCustomProcessorTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"custom\"");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)"hey");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String foo = (String)mbeanServer.getAttribute(on, "Foo");
        ManagedCustomProcessorTest.assertEquals((String)"hey", (String)foo);
        mbeanServer.setAttribute(on, new Attribute("Foo", "changed"));
        this.resetMocks();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)"changed");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedCustomProcessorTest.assertEquals((String)"Started", (String)state);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").process((Processor)new MyCustomProcessor())).id("custom")).to("mock:result");
            }
        };
    }

    @ManagedResource(description="My Managed Component")
    public static class MyCustomProcessor
    extends ServiceSupport
    implements Processor {
        private String foo = "hey";

        @ManagedAttribute
        public String getFoo() {
            return this.foo;
        }

        @ManagedAttribute
        public void setFoo(String foo) {
            this.foo = foo;
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getIn().setHeader("foo", (Object)this.getFoo());
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }
    }
}

