/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedDataFormatTest
extends ManagementTestSupport {
    public void testManageDataFormat() throws Exception {
        if (ManagedDataFormatTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=dataformats,*"), null);
        ManagedDataFormatTest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedDataFormatTest.assertNotNull((Object)json);
        ManagedDataFormatTest.assertTrue((boolean)json.contains("\"title\": \"String Encoding\""));
        ManagedDataFormatTest.assertTrue((boolean)json.contains("\"modelJavaType\": \"org.apache.camel.model.dataformat.StringDataFormat\""));
        ManagedDataFormatTest.assertTrue((boolean)json.contains("\"charset\": { \"kind\": \"attribute\""));
        ManagedDataFormatTest.assertTrue((boolean)json.contains("\"value\": \"iso-8859-1\""));
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedDataFormatTest.assertNotNull((Object)data);
        ManagedDataFormatTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedDataFormatTest.assertNotNull((Object)data);
        ManagedDataFormatTest.assertEquals((int)1, (int)data.size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:test").unmarshal().string("iso-8859-1").to("mock:result");
            }
        };
    }
}

