/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedEndpointExplainTest
extends ManagementTestSupport {
    public void testManageEndpointExplain() throws Exception {
        if (ManagedEndpointExplainTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"seda://test\"");
        ManagedEndpointExplainTest.assertTrue((boolean)mbeanServer.isRegistered(on));
        on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://result\"");
        ManagedEndpointExplainTest.assertTrue((boolean)mbeanServer.isRegistered(on));
        on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"log://foo\\?groupDelay=2000&groupSize=5&level=WARN\"");
        ManagedEndpointExplainTest.assertTrue((boolean)mbeanServer.isRegistered(on));
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedEndpointExplainTest.assertEquals((int)4, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedEndpointExplainTest.assertEquals((int)27, (int)data.size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:test").to("log:foo?groupDelay=2000&groupSize=5&level=WARN")).to("mock:result");
            }
        };
    }
}

