/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.IOException;
import java.sql.SQLException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;

public class ManagedFailoverLoadBalancerTest
extends ManagementTestSupport {
    public void testManageFailoverLoadBalancer() throws Exception {
        if (ManagedFailoverLoadBalancerTest.isPlatform("aix")) {
            return;
        }
        this.getMockEndpoint("mock:foo").whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                throw new IOException("Forced");
            }
        });
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedFailoverLoadBalancerTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedFailoverLoadBalancerTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedFailoverLoadBalancerTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        Integer size = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedFailoverLoadBalancerTest.assertEquals((int)2, (int)size);
        Boolean roundRobin = (Boolean)mbeanServer.getAttribute(on, "RoundRobin");
        ManagedFailoverLoadBalancerTest.assertEquals((boolean)true, (boolean)roundRobin);
        Boolean sticky = (Boolean)mbeanServer.getAttribute(on, "Sticky");
        ManagedFailoverLoadBalancerTest.assertEquals((boolean)true, (boolean)sticky);
        Integer attempts = (Integer)mbeanServer.getAttribute(on, "MaximumFailoverAttempts");
        ManagedFailoverLoadBalancerTest.assertEquals((int)3, (int)attempts);
        String exceptions = (String)mbeanServer.getAttribute(on, "Exceptions");
        ManagedFailoverLoadBalancerTest.assertEquals((String)"java.io.IOException,java.sql.SQLException", (String)exceptions);
        String id = (String)mbeanServer.getAttribute(on, "LastGoodProcessorId");
        ManagedFailoverLoadBalancerTest.assertEquals((String)"bar", (String)id);
        TabularData data = (TabularData)mbeanServer.invoke(on, "exceptionStatistics", null, null);
        ManagedFailoverLoadBalancerTest.assertNotNull((Object)data);
        ManagedFailoverLoadBalancerTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedFailoverLoadBalancerTest.assertNotNull((Object)data);
        ManagedFailoverLoadBalancerTest.assertEquals((int)3, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedFailoverLoadBalancerTest.assertNotNull((Object)data);
        ManagedFailoverLoadBalancerTest.assertEquals((int)5, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedFailoverLoadBalancerTest.assertNotNull((Object)json);
        ManagedFailoverLoadBalancerTest.assertTrue((boolean)json.contains("\"description\": \"Balances message processing among a number of nodes"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)this.from("direct:start").loadBalance().failover(3, false, true, true, new Class[]{IOException.class, SQLException.class}).id("mysend")).to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

