/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.management.MyDummyProcessor;
import org.apache.camel.model.RouteDefinition;

public class ManagedProcessTest
extends ManagementTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyDummyProcessor());
        return jndi;
    }

    public void testManageProcess() throws Exception {
        if (ManagedProcessTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedProcessTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedProcessTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedProcessTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        String ref = (String)mbeanServer.getAttribute(on, "Ref");
        ManagedProcessTest.assertEquals((String)"foo", (String)ref);
        String processorClassName = (String)mbeanServer.getAttribute(on, "ProcessorClassName");
        ManagedProcessTest.assertEquals((String)"org.apache.camel.management.MyDummyProcessor", (String)processorClassName);
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedProcessTest.assertNotNull((Object)data);
        ManagedProcessTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedProcessTest.assertNotNull((Object)data);
        ManagedProcessTest.assertEquals((int)3, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedProcessTest.assertNotNull((Object)json);
        ManagedProcessTest.assertTrue((boolean)json.contains("\"description\": \"Calls a Camel processor."));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").process("foo")).id("mysend")).to("mock:foo");
            }
        };
    }
}

