/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedRecipientListTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().getManagementAgent().setStatisticsLevel(ManagementStatisticsLevel.Extended);
        return context;
    }

    public void testManageRecipientList() throws Exception {
        if (ManagedRecipientListTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(2);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "whereto", (Object)"mock:foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "whereto", (Object)"mock:foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "whereto", (Object)"mock:bar");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedRecipientListTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedRecipientListTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRecipientListTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        Boolean parallel = (Boolean)mbeanServer.getAttribute(on, "ParallelProcessing");
        ManagedRecipientListTest.assertEquals((boolean)false, (boolean)parallel);
        String lan = (String)mbeanServer.getAttribute(on, "ExpressionLanguage");
        ManagedRecipientListTest.assertEquals((String)"header", (String)lan);
        String uri = (String)mbeanServer.getAttribute(on, "Expression");
        ManagedRecipientListTest.assertEquals((String)"whereto", (String)uri);
        TabularData data = (TabularData)mbeanServer.invoke(on, "extendedInformation", null, null);
        ManagedRecipientListTest.assertNotNull((Object)data);
        ManagedRecipientListTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedRecipientListTest.assertNotNull((Object)data);
        ManagedRecipientListTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedRecipientListTest.assertNotNull((Object)data);
        ManagedRecipientListTest.assertEquals((int)17, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedRecipientListTest.assertNotNull((Object)json);
        ManagedRecipientListTest.assertTrue((boolean)json.contains("\"description\": \"Routes messages to a number of dynamically specified recipients (dynamic to)"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").recipientList((Expression)this.header("whereto")).id("mysend");
            }
        };
    }
}

