/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;

public class ManagedRouteContextTracerTest
extends ManagementTestSupport {
    public void testRouteTracing() throws Exception {
        if (ManagedRouteContextTracerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on1 = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route1\"");
        ObjectName on2 = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route2\"");
        MockEndpoint traced = this.getMockEndpoint("mock:traced");
        traced.setExpectedMessageCount(2);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.setExpectedMessageCount(1);
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.setExpectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Boolean tracing = (Boolean)mbeanServer.getAttribute(on1, "Tracing");
        ManagedRouteContextTracerTest.assertEquals((String)"Tracing should be enabled for route 1", (boolean)true, (boolean)tracing);
        Boolean tracing2 = (Boolean)mbeanServer.getAttribute(on2, "Tracing");
        ManagedRouteContextTracerTest.assertEquals((String)"Tracing should be disabled for route 2", (boolean)false, (boolean)tracing2);
        mbeanServer.setAttribute(on2, new Attribute("Tracing", Boolean.TRUE));
        traced.reset();
        traced.setExpectedMessageCount(1);
        result.reset();
        result.setExpectedMessageCount(0);
        foo.reset();
        foo.setExpectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Tracer tracer = new Tracer();
                tracer.setDestinationUri("mock:traced");
                tracer.setLogLevel(LoggingLevel.OFF);
                ManagedRouteContextTracerTest.this.context.addInterceptStrategy((InterceptStrategy)tracer);
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
                this.from("direct:foo").noTracing().to("mock:foo");
            }
        };
    }
}

