/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedRouteStopTest
extends ManagementTestSupport {
    public void testStopRoute() throws Exception {
        if (ManagedRouteStopTest.isPlatform("aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteStopTest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        ManagedRouteStopTest.assertEquals((String)"Should be registered", (boolean)true, (boolean)registered);
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        ManagedRouteStopTest.assertEquals((String)"direct://start", (String)uri);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopTest.assertEquals((String)"Should be started", (String)ServiceStatus.Started.name(), (String)state);
        String uptime = (String)mbeanServer.getAttribute(on, "Uptime");
        ManagedRouteStopTest.assertNotNull((Object)uptime);
        this.log.info("Uptime: {}", (Object)uptime);
        mbeanServer.invoke(on, "stop", null, null);
        registered = mbeanServer.isRegistered(on);
        ManagedRouteStopTest.assertEquals((String)"Should be registered", (boolean)true, (boolean)registered);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopTest.assertEquals((String)"Should be stopped", (String)ServiceStatus.Stopped.name(), (String)state);
        uptime = (String)mbeanServer.getAttribute(on, "Uptime");
        ManagedRouteStopTest.assertEquals((String)"", (String)uptime);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

