/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedRoutingSlipTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().getManagementAgent().setStatisticsLevel(ManagementStatisticsLevel.Extended);
        return context;
    }

    public void testManageRoutingSlip() throws Exception {
        if (ManagedRoutingSlipTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(2);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "whereTo", (Object)"direct:foo,direct:foo,direct:bar");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedRoutingSlipTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedRoutingSlipTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRoutingSlipTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        String lan = (String)mbeanServer.getAttribute(on, "ExpressionLanguage");
        ManagedRoutingSlipTest.assertEquals((String)"header", (String)lan);
        String uri = (String)mbeanServer.getAttribute(on, "Expression");
        ManagedRoutingSlipTest.assertEquals((String)"whereTo", (String)uri);
        TabularData data = (TabularData)mbeanServer.invoke(on, "extendedInformation", null, null);
        ManagedRoutingSlipTest.assertNotNull((Object)data);
        ManagedRoutingSlipTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedRoutingSlipTest.assertNotNull((Object)data);
        ManagedRoutingSlipTest.assertEquals((int)3, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedRoutingSlipTest.assertNotNull((Object)data);
        ManagedRoutingSlipTest.assertEquals((int)6, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedRoutingSlipTest.assertNotNull((Object)json);
        ManagedRoutingSlipTest.assertTrue((boolean)json.contains("\"description\": \"Routes a message through a series of steps that are pre-determined (the slip)"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routingSlip((Expression)this.header("whereTo")).id("mysend");
                this.from("direct:foo").to("mock:foo");
                this.from("direct:bar").to("mock:bar");
            }
        };
    }
}

