/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.language.XPath;

public class ClaimCheckTest
extends ContextTestSupport {
    public static Map<String, Object> dataStore = new HashMap<String, Object>();

    public void testClaimCheck() throws Exception {
        String body = "<order custId=\"123\"><lotsOfContent/></order>";
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(1);
        ((ValueBuilder)resultEndpoint.message(0).body()).equals(body);
        MockEndpoint testCheckpointEndpoint = this.getMockEndpoint("mock:testCheckpoint");
        testCheckpointEndpoint.expectedMessageCount(1);
        testCheckpointEndpoint.expectedHeaderReceived("claimCheck", (Object)"123");
        ((ValueBuilder)testCheckpointEndpoint.message(0).body()).isNull();
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("checkLuggage", (Object)new CheckLuggageBean());
        jndi.bind("dataEnricher", (Object)new DataEnricherBean());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to(new String[]{"bean:checkLuggage", "mock:testCheckpoint", "bean:dataEnricher", "mock:result"});
            }
        };
    }

    public static final class DataEnricherBean {
        public void addDataBackIn(Exchange exchange, @Header(value="claimCheck") String claimCheck) {
            exchange.getIn().setBody(dataStore.get(claimCheck));
            dataStore.remove(claimCheck);
            exchange.getIn().removeHeader("claimCheck");
        }
    }

    public static final class CheckLuggageBean {
        public void checkLuggage(Exchange exchange, @Body String body, @XPath(value="/order/@custId") String custId) {
            dataStore.put(custId, body);
            exchange.getIn().setHeader("claimCheck", (Object)custId);
            exchange.getIn().setBody(null);
        }
    }
}

