/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;

public class CustomLoadBalanceTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").loadBalance((LoadBalancer)new MyLoadBalancer()).to(new String[]{"mock:x", "mock:y", "mock:z"});
            }
        };
    }

    public void testCustomLoadBalancer() throws Exception {
        this.x.expectedBodiesReceived(new Object[]{"x", "x", "x"});
        this.y.expectedBodiesReceived(new Object[]{"y", "y"});
        this.z.expectedBodiesReceived(new Object[]{"foo", "bar", "baz"});
        this.template.sendBody("direct:start", (Object)"x");
        this.template.sendBody("direct:start", (Object)"y");
        this.template.sendBody("direct:start", (Object)"foo");
        this.template.sendBody("direct:start", (Object)"bar");
        this.template.sendBody("direct:start", (Object)"y");
        this.template.sendBody("direct:start", (Object)"x");
        this.template.sendBody("direct:start", (Object)"x");
        this.template.sendBody("direct:start", (Object)"baz");
        this.assertMockEndpointsSatisfied();
    }

    public static class MyLoadBalancer
    extends LoadBalancerSupport {
        public boolean process(Exchange exchange, AsyncCallback callback) {
            String body = (String)exchange.getIn().getBody(String.class);
            try {
                if ("x".equals(body)) {
                    ((Processor)this.getProcessors().get(0)).process(exchange);
                } else if ("y".equals(body)) {
                    ((Processor)this.getProcessors().get(1)).process(exchange);
                } else {
                    ((Processor)this.getProcessors().get(2)).process(exchange);
                }
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
    }
}

