/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class DefaultErrorHandlerOnPrepareTest
extends ContextTestSupport {
    public void testDefaultErrorHandlerOnPrepare() throws Exception {
        Exchange out = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        DefaultErrorHandlerOnPrepareTest.assertNotNull((Object)out);
        DefaultErrorHandlerOnPrepareTest.assertTrue((String)"Should be failed", (boolean)out.isFailed());
        DefaultErrorHandlerOnPrepareTest.assertIsInstanceOf(IllegalArgumentException.class, out.getException());
        DefaultErrorHandlerOnPrepareTest.assertEquals((Object)"Forced", (Object)out.getIn().getHeader("FailedBecause"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().onPrepareFailure((Processor)new MyPrepareProcessor()));
                ((RouteDefinition)this.from("direct:start").log("Incoming ${body}")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }

    public static class MyPrepareProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            Exception cause = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
            exchange.getIn().setHeader("FailedBecause", (Object)cause.getMessage());
        }
    }
}

