/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class DynamicRouterOnExceptionTest
extends ContextTestSupport {
    public void testOk() throws Exception {
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        MockEndpoint route = this.getMockEndpoint("mock:route");
        route.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testException() throws Exception {
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        MockEndpoint route = this.getMockEndpoint("mock:route");
        route.whenExchangeReceived(1, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setException((Throwable)new IllegalArgumentException("Forced"));
            }
        });
        route.whenExchangeReceived(2, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Bye World");
            }
        });
        route.expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testExceptionTwo() throws Exception {
        this.getMockEndpoint("mock:end").expectedMessageCount(2);
        MockEndpoint route = this.getMockEndpoint("mock:route");
        route.whenExchangeReceived(1, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setException((Throwable)new IllegalArgumentException("Forced"));
            }
        });
        route.whenExchangeReceived(2, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Bye World");
            }
        });
        route.whenExchangeReceived(3, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setException((Throwable)new IllegalArgumentException("Forced"));
            }
        });
        route.whenExchangeReceived(4, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Bye World");
            }
        });
        route.expectedMessageCount(4);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).maximumRedeliveries(5);
                this.from("direct:start").dynamicRouter((Expression)this.method(DynamicRouterOnExceptionTest.class, "whereTo")).to("mock:end");
            }
        };
    }

    public static String whereTo(Exchange exchange) {
        Boolean invoked = (Boolean)exchange.getProperty("invoked", Boolean.class);
        if (invoked == null) {
            exchange.setProperty("invoked", (Object)true);
            return "mock:route";
        }
        return null;
    }
}

