/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;

public class MulticastSubUnitOfWorkTest
extends ContextTestSupport {
    private static int counter;

    public void testOK() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testError() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Donkey was here"});
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        MulticastSubUnitOfWorkTest.assertEquals((int)4, (int)counter);
    }

    public void testMulticastException() throws Exception {
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Hello", "Hi", "Bye"});
        this.template.sendBody("direct:e", (Object)"Hello");
        this.template.sendBody("direct:e", (Object)"Hi");
        this.template.sendBody("direct:e", (Object)"Bye");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").useOriginalMessage().maximumRedeliveries(3).redeliveryDelay(0L));
                ((MulticastDefinition)((MulticastDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:start")).process((Processor)new MyPreProcessor())).multicast().shareUnitOfWork().to("direct:a")).to("direct:b")).end().to("mock:result");
                this.from("direct:a").to("mock:a");
                ((RouteDefinition)this.from("direct:b").process((Processor)new MyProcessor())).to("mock:b");
                ((MulticastDefinition)((MulticastDefinition)this.from("direct:e").multicast().shareUnitOfWork().throwException((Exception)new IllegalArgumentException("exception1"))).throwException((Exception)new IllegalArgumentException("exception2"))).end();
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if (body.contains("Donkey")) {
                counter++;
                throw new IllegalArgumentException("Donkey not allowed");
            }
        }
    }

    public static class MyPreProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if (body.startsWith("Bye")) {
                exchange.getIn().setBody((Object)"Donkey was here");
            }
        }
    }
}

