/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;

public class PolicyPerRouteTest
extends ContextTestSupport {
    public void testPolicy() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:response").expectedMessageCount(1);
        this.getMockEndpoint("mock:response").expectedHeaderReceived("foo", (Object)"policy finished execution");
        this.template.sendBody("direct:send", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MyPolicy foo = (MyPolicy)this.context.getRegistry().lookupByNameAndType("foo", MyPolicy.class);
        PolicyPerRouteTest.assertEquals((String)"Should only be invoked 1 time", (int)1, (int)foo.getInvoked());
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyPolicy("foo"));
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:start").policy("foo").to("mock:foo")).to("mock:bar")).to("mock:result");
                ((RouteDefinition)this.from("direct:send").to("direct:start")).to("mock:response");
            }
        };
    }

    public static class MyPolicy
    implements Policy {
        private final String name;
        private int invoked;

        public MyPolicy(String name) {
            this.name = name;
        }

        public void beforeWrap(RouteContext routeContext, ProcessorDefinition<?> definition) {
        }

        public Processor wrap(RouteContext routeContext, final Processor processor) {
            return new Processor(){

                public void process(Exchange exchange) throws Exception {
                    MyPolicy.this.invoked++;
                    exchange.getIn().setHeader(MyPolicy.this.name, (Object)"was wrapped");
                    processor.process(exchange);
                    exchange.getIn().setHeader(MyPolicy.this.name, (Object)"policy finished execution");
                }
            };
        }

        public int getInvoked() {
            return this.invoked;
        }
    }
}

