/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.RouteDefinition;

public class RecipientListMEPTest
extends ContextTestSupport {
    public void testMEPInOnly() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World", "Hello Again"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World", "Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Hello Again");
        this.assertMockEndpointsSatisfied();
    }

    public void testMEPInOutOnly() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World", "Hello Again"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World", "Bye World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        RecipientListMEPTest.assertEquals((String)"Bye World", (String)out);
        out = (String)this.template.requestBody("direct:start", (Object)"Hello Again", String.class);
        RecipientListMEPTest.assertEquals((String)"Bye World", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RecipientListDefinition)this.from("direct:start").recipientList().constant((Object)"seda:foo?exchangePattern=InOut")).to("mock:result");
                ((RouteDefinition)this.from("seda:foo").to("mock:foo")).transform().constant((Object)"Bye World");
            }
        };
    }
}

