/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class RedeliverToSubRouteTest
extends ContextTestSupport {
    public void testRedeliverToSubRoute() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World", "Hello World", "Hello World"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IOException.class).maximumRedeliveries(2).redeliveryDelay(0L);
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:a")).to("direct:sub")).to("mock:c");
                ((RouteDefinition)this.from("direct:sub").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:b")).process((Processor)new MyProcessor());
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        private int counter;

        public void process(Exchange exchange) throws Exception {
            if (this.counter++ < 2) {
                throw new IOException("Forced");
            }
            exchange.getIn().setBody((Object)"Bye World");
        }
    }
}

