/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class ReduceStacksNeededDuringRoutingTest
extends ContextTestSupport {
    @Override
    protected boolean useJmx() {
        return true;
    }

    public void testReduceStacksNeeded() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:start").to("log:foo")).to("log:bar")).to("log:baz")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        try {
                            throw new IllegalArgumentException("Forced to dump stacktrace");
                        }
                        catch (Exception e) {
                            e.fillInStackTrace();
                            log.info("There are " + e.getStackTrace().length + " lines in the stacktrace");
                            log.error("Dump stacktrace to log", (Throwable)e);
                            return;
                        }
                    }
                })).to("mock:result");
            }
        };
    }
}

