/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.spi.IdAware;

public class SimpleProcessorIdAwareTest
extends ContextTestSupport {
    public void testIdAware() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        List matches = this.context.getRoute("foo").filter("b*");
        SimpleProcessorIdAwareTest.assertEquals((int)2, (int)matches.size());
        Processor bar = (Processor)matches.get(0);
        Processor baz = (Processor)matches.get(1);
        SimpleProcessorIdAwareTest.assertEquals((String)"bar", (String)((IdAware)bar).getId());
        SimpleProcessorIdAwareTest.assertEquals((String)"baz", (String)((IdAware)baz).getId());
        bar = this.context.getProcessor("bar");
        SimpleProcessorIdAwareTest.assertNotNull((Object)bar);
        baz = this.context.getProcessor("baz");
        SimpleProcessorIdAwareTest.assertNotNull((Object)baz);
        Processor unknown = this.context.getProcessor("unknown");
        SimpleProcessorIdAwareTest.assertNull((Object)unknown);
        Processor result = this.context.getProcessor("result");
        SimpleProcessorIdAwareTest.assertNotNull((Object)result);
        ProcessorDefinition def = this.context.getProcessorDefinition("result");
        SimpleProcessorIdAwareTest.assertNotNull((Object)def);
        SimpleProcessorIdAwareTest.assertEquals((String)"result", (String)def.getId());
        SendDefinition send = SimpleProcessorIdAwareTest.assertIsInstanceOf(SendDefinition.class, def);
        SimpleProcessorIdAwareTest.assertNotNull((Object)send);
        SimpleProcessorIdAwareTest.assertEquals((String)"mock:result", (String)send.getEndpointUri());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").routeId("foo").choice().when((Predicate)this.header("bar")).to("log:bar")).id("bar")).otherwise().to("mock:result")).id("result")).end().to("log:baz").id("baz");
            }
        };
    }
}

