/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;

public class SplitterUoWIssueTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        SplitterUoWIssueTest.deleteDirectory("target/splitter");
        super.setUp();
    }

    public void testSplitterUoWIssue() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"A", "B", "C", "D", "E"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A,B,C,D,E"});
        this.template.sendBodyAndHeader("file:target/splitter", (Object)"A,B,C,D,E", "CamelFileName", (Object)"splitme.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitterTwoFilesUoWIssue() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"A", "B", "C", "D", "E", "F", "G", "H", "I"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A,B,C,D,E", "F,G,H,I"});
        this.template.sendBodyAndHeader("file:target/splitter", (Object)"A,B,C,D,E", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file:target/splitter", (Object)"F,G,H,I", "CamelFileName", (Object)"b.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("file:target/splitter?delete=true&sortBy=file:name").split((Expression)this.body().tokenize(",")).to("seda:queue")).end().log("End of file ${file:name}").to("mock:result");
                ((RouteDefinition)this.from("seda:queue").log("Token: ${body}")).to("mock:foo");
            }
        };
    }
}

