/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;

public class ThrottlerMethodCallTest
extends ContextTestSupport {
    private static final int INTERVAL = 500;
    protected int messageCount = 9;

    protected boolean canTest() {
        return !ThrottlerMethodCallTest.isPlatform("windows");
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBean", (Object)this);
        return jndi;
    }

    public long getMessagesPerSecond() {
        return 1L;
    }

    public void testConfigurationWithMethodCallExpression() throws Exception {
        if (!this.canTest()) {
            return;
        }
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(this.messageCount);
        ExecutorService executor = Executors.newFixedThreadPool(this.messageCount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.messageCount; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ThrottlerMethodCallTest.this.template.sendBody("direct:expressionMethod", (Object)"<message>payload</message>");
                }
            });
        }
        resultEndpoint.assertIsSatisfied();
        long minimumTime = (this.messageCount - 1) * 500;
        long delta = System.currentTimeMillis() - start + 200L;
        ThrottlerMethodCallTest.assertTrue((String)("Should take at least " + minimumTime + "ms, was: " + delta), (delta >= minimumTime ? 1 : 0) != 0);
        executor.shutdownNow();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:expressionMethod").throttle((Expression)this.method("myBean", "getMessagesPerSecond")).timePeriodMillis(500L).to(new String[]{"log:result", "mock:result"});
            }
        };
    }
}

