/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.builder.RouteBuilder;

public class ToDynamicTest
extends ContextTestSupport {
    public void testToDynamic() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Camel", "foo", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"bar");
        this.assertMockEndpointsSatisfied();
    }

    public void testToDynamicInvalid() throws Exception {
        try {
            this.template.sendBody("direct:start", (Object)"Hello Camel");
            ToDynamicTest.fail((String)"Should fail");
        }
        catch (CamelExecutionException e) {
            ToDynamicTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").toD("mock:${header.foo}");
            }
        };
    }
}

