/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.processor.UnmarshalProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ServiceSupport;

public class UnmarshalProcessorTest
extends TestSupport {
    public void testDataFormatReturnsSameExchange() throws Exception {
        Exchange exchange = this.createExchangeWithBody((CamelContext)new DefaultCamelContext(), "body");
        UnmarshalProcessor processor = new UnmarshalProcessor((DataFormat)new MyDataFormat(exchange));
        processor.process(exchange);
        UnmarshalProcessorTest.assertEquals((String)"UnmarshalProcessor did not copy OUT from IN message", (Object)"body", (Object)exchange.getOut().getBody());
    }

    public void testDataFormatReturnsAnotherExchange() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        Exchange exchange = this.createExchangeWithBody((CamelContext)context, "body");
        Exchange exchange2 = this.createExchangeWithBody((CamelContext)context, "body2");
        UnmarshalProcessor processor = new UnmarshalProcessor((DataFormat)new MyDataFormat(exchange2));
        processor.process(exchange);
        Exception e = exchange.getException();
        UnmarshalProcessorTest.assertNotNull((Object)e);
        UnmarshalProcessorTest.assertEquals((String)("The returned exchange " + exchange2 + " is not the same as " + exchange + " provided to the DataFormat"), (String)e.getMessage());
    }

    public void testDataFormatReturnsMessage() throws Exception {
        Exchange exchange = this.createExchangeWithBody((CamelContext)new DefaultCamelContext(), "body");
        DefaultMessage out = new DefaultMessage();
        out.setBody(new Object());
        UnmarshalProcessor processor = new UnmarshalProcessor((DataFormat)new MyDataFormat((Message)out));
        processor.process(exchange);
        UnmarshalProcessorTest.assertSame((String)"UnmarshalProcessor did not make use of the returned OUT message", (Object)out, (Object)exchange.getOut());
        UnmarshalProcessorTest.assertSame((String)"UnmarshalProcessor did change the body bound to the OUT message", (Object)out.getBody(), (Object)exchange.getOut().getBody());
    }

    public void testDataFormatReturnsBody() throws Exception {
        Exchange exchange = this.createExchangeWithBody((CamelContext)new DefaultCamelContext(), "body");
        Object unmarshalled = new Object();
        UnmarshalProcessor processor = new UnmarshalProcessor((DataFormat)new MyDataFormat(unmarshalled));
        processor.process(exchange);
        UnmarshalProcessorTest.assertSame((String)"UnmarshalProcessor did not make use of the returned object being returned while unmarshalling", (Object)unmarshalled, (Object)exchange.getOut().getBody());
    }

    private static class MyDataFormat
    extends ServiceSupport
    implements DataFormat {
        private final Object object;

        MyDataFormat(Exchange exchange) {
            this.object = exchange;
        }

        MyDataFormat(Message message) {
            this.object = message;
        }

        MyDataFormat(Object unmarshalled) {
            this.object = unmarshalled;
        }

        public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
            throw new IllegalAccessException("This method is not expected to be used by UnmarshalProcessor");
        }

        public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
            return this.object;
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }
    }
}

