/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class WireTapUsingFireAndForgetCopyTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testFireAndForgetUsingProcessor() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").wireTap("direct:foo", true, new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        exchange.getIn().setBody((Object)("Bye " + body));
                        exchange.getIn().setHeader("foo", (Object)"bar");
                    }
                }).to("mock:result");
                this.from("direct:foo").to("mock:foo");
            }
        });
        this.context.start();
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"World"});
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"Bye World"});
        foo.expectedHeaderReceived("foo", (Object)"bar");
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
        Exchange e1 = (Exchange)result.getReceivedExchanges().get(0);
        Exchange e2 = (Exchange)foo.getReceivedExchanges().get(0);
        WireTapUsingFireAndForgetCopyTest.assertNotSame((String)"Should not be same Exchange", (Object)e1, (Object)e2);
        WireTapUsingFireAndForgetCopyTest.assertEquals((String)"direct://start", (String)e1.getFromEndpoint().getEndpointUri());
        WireTapUsingFireAndForgetCopyTest.assertEquals((String)"direct://start", (String)e2.getFromEndpoint().getEndpointUri());
    }

    public void testFireAndForgetUsingProcessor2() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").wireTap("direct:foo", true, new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        exchange.getIn().setBody((Object)("Bye " + body));
                        exchange.getIn().setHeader("foo", (Object)"bar");
                    }
                }).to("mock:result");
                this.from("direct:foo").to("mock:foo");
            }
        });
        this.context.start();
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"World"});
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"Bye World"});
        foo.expectedHeaderReceived("foo", (Object)"bar");
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
        Exchange e1 = (Exchange)result.getReceivedExchanges().get(0);
        Exchange e2 = (Exchange)foo.getReceivedExchanges().get(0);
        WireTapUsingFireAndForgetCopyTest.assertNotSame((String)"Should not be same Exchange", (Object)e1, (Object)e2);
        WireTapUsingFireAndForgetCopyTest.assertEquals((String)"direct://start", (String)e1.getFromEndpoint().getEndpointUri());
        WireTapUsingFireAndForgetCopyTest.assertEquals((String)"direct://start", (String)e2.getFromEndpoint().getEndpointUri());
    }

    public void testFireAndForgetUsingExpression() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").wireTap("direct:foo", true, (Expression)this.simple("Bye ${body}")).to("mock:result");
                this.from("direct:foo").to("mock:foo");
            }
        });
        this.context.start();
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"World"});
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
        Exchange e1 = (Exchange)result.getReceivedExchanges().get(0);
        Exchange e2 = (Exchange)foo.getReceivedExchanges().get(0);
        WireTapUsingFireAndForgetCopyTest.assertNotSame((String)"Should not be same Exchange", (Object)e1, (Object)e2);
        WireTapUsingFireAndForgetCopyTest.assertEquals((String)"direct://start", (String)e1.getFromEndpoint().getEndpointUri());
        WireTapUsingFireAndForgetCopyTest.assertEquals((String)"direct://start", (String)e2.getFromEndpoint().getEndpointUri());
    }

    public void testFireAndForgetUsingExpression2() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").wireTap("direct:foo", true, (Expression)this.simple("Bye ${body}")).to("mock:result");
                this.from("direct:foo").to("mock:foo");
            }
        });
        this.context.start();
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"World"});
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
        Exchange e1 = (Exchange)result.getReceivedExchanges().get(0);
        Exchange e2 = (Exchange)foo.getReceivedExchanges().get(0);
        WireTapUsingFireAndForgetCopyTest.assertNotSame((String)"Should not be same Exchange", (Object)e1, (Object)e2);
        WireTapUsingFireAndForgetCopyTest.assertEquals((String)"direct://start", (String)e1.getFromEndpoint().getEndpointUri());
        WireTapUsingFireAndForgetCopyTest.assertEquals((String)"direct://start", (String)e2.getFromEndpoint().getEndpointUri());
    }
}

