/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class AggregateMultipleSourceTest
extends ContextTestSupport {
    public void testAggregateMultipleSourceTest() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectsNoDuplicates((Expression)AggregateMultipleSourceTest.body());
        mock.setResultWaitTime(20000L);
        for (int i = 0; i < 40; ++i) {
            if (i % 2 == 0) {
                this.template.sendBodyAndHeader("seda:foo", (Object)("" + i), "type", (Object)"A");
                continue;
            }
            if (i % 5 == 0) {
                this.template.sendBodyAndHeader("seda:bar", (Object)("" + i), "type", (Object)"A");
                continue;
            }
            this.template.sendBodyAndHeader("seda:baz", (Object)("" + i), "type", (Object)"A");
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo").to("direct:aggregate");
                this.from("seda:bar").to("direct:aggregate");
                this.from("seda:baz").to("direct:aggregate");
                ((AggregateDefinition)this.from("direct:aggregate").aggregate((Expression)this.header("type"), (AggregationStrategy)new MyAggregationStrategy()).completionSize(25).completionTimeout(5000L).to("mock:result")).end();
            }
        };
    }

    private static class MyAggregationStrategy
    implements AggregationStrategy {
        private MyAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body = (String)oldExchange.getIn().getBody(String.class);
            String newBody = (String)newExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body + newBody));
            return oldExchange;
        }
    }
}

