/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.processor.aggregate.TimeoutAwareAggregationStrategy;
import org.apache.camel.processor.aggregator.AbstractDistributedTest;
import org.apache.camel.spi.AggregationRepository;

public class DistributedTimeoutTest
extends AbstractDistributedTest {
    private MemoryAggregationRepository sharedAggregationRepository = new MemoryAggregationRepository(true);
    private final AtomicInteger invoked = new AtomicInteger();
    private volatile Exchange receivedExchange;
    private volatile int receivedIndex;
    private volatile int receivedTotal;
    private volatile long receivedTimeout;

    public void testAggregateTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        MockEndpoint mock2 = this.getMockEndpoint2("mock:aggregated");
        mock.expectedMessageCount(0);
        mock2.expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template2.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        Thread.sleep(3000L);
        mock.assertIsSatisfied();
        mock2.assertIsSatisfied();
        DistributedTimeoutTest.assertEquals((int)1, (int)this.invoked.get());
        DistributedTimeoutTest.assertNotNull((Object)this.receivedExchange);
        DistributedTimeoutTest.assertEquals((Object)"AB", (Object)this.receivedExchange.getIn().getBody());
        DistributedTimeoutTest.assertEquals((int)-1, (int)this.receivedIndex);
        DistributedTimeoutTest.assertEquals((int)-1, (int)this.receivedTotal);
        DistributedTimeoutTest.assertEquals((long)2000L, (long)this.receivedTimeout);
        mock.reset();
        mock.expectedMessageCount(0);
        mock2.reset();
        mock2.expectedBodiesReceived(new Object[]{"ABC"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template2.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template2.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)123);
        mock2.assertIsSatisfied(2000L);
        mock.assertIsSatisfied(5000L);
        DistributedTimeoutTest.assertEquals((int)1, (int)this.invoked.get());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new MyAggregationStrategy()).aggregationRepository((AggregationRepository)DistributedTimeoutTest.this.sharedAggregationRepository).optimisticLocking().discardOnCompletionTimeout().completionSize(3).completionTimeout(2000L).to("mock:aggregated");
            }
        };
    }

    private class MyAggregationStrategy
    implements TimeoutAwareAggregationStrategy {
        private MyAggregationStrategy() {
        }

        public void timeout(Exchange oldExchange, int index, int total, long timeout) {
            DistributedTimeoutTest.this.invoked.incrementAndGet();
            DistributedTimeoutTest.this.receivedExchange = oldExchange;
            DistributedTimeoutTest.this.receivedIndex = index;
            DistributedTimeoutTest.this.receivedTotal = total;
            DistributedTimeoutTest.this.receivedTimeout = timeout;
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body = (String)oldExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
            return oldExchange;
        }
    }
}

