/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutingSlip;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncEndpointRoutingSlipBean2Test
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBean", (Object)new MyRoutingSlipBean());
        return jndi;
    }

    public void testAsyncEndpoint() throws Exception {
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncEndpointRoutingSlipBean2Test.assertEquals((String)"Bye World", (String)reply);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointRoutingSlipBean2Test.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.from("direct:start").bean((Object)"myBean");
            }
        };
    }

    public static class MyRoutingSlipBean {
        @RoutingSlip
        public String doSomething() {
            return "async:bye:camel,async:bye:world";
        }
    }
}

