/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class EnricherAggregateOnExceptionTest
extends ContextTestSupport {
    public void testEnrichTrueOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    public void testEnrichTrueKaboom() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"I cannot do this"});
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.assertMockEndpointsSatisfied();
    }

    public void testEnrichFalseOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start2", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    public void testEnrichFalseKaboom() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start2", (Object)"Kaboom");
            EnricherAggregateOnExceptionTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            EnricherAggregateOnExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            EnricherAggregateOnExceptionTest.assertEquals((String)"I cannot do this", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").enrich("direct:foo", (AggregationStrategy)new MyAggregationStrategy(), true)).to("mock:result");
                ((RouteDefinition)this.from("direct:start2").enrich("direct:foo", (AggregationStrategy)new MyAggregationStrategy(), false)).to("mock:result");
                this.from("direct:foo").process((Processor)new MyProcessor());
            }
        };
    }

    public static class MyAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (newExchange.getException() != null) {
                oldExchange.getIn().setBody((Object)newExchange.getException().getMessage());
                return oldExchange;
            }
            oldExchange.getIn().setBody(newExchange.getIn().getBody());
            return oldExchange;
        }
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if (body.startsWith("Kaboom")) {
                throw new IllegalArgumentException("I cannot do this");
            }
            exchange.getIn().setBody((Object)("Hello " + body));
        }
    }
}

