/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.enricher.SampleAggregator;

public class PollEnricherTest
extends ContextTestSupport {
    private static SampleAggregator aggregationStrategy = new SampleAggregator();
    protected MockEndpoint mock;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.mock = this.getMockEndpoint("mock:mock");
    }

    public void testPollEnrichInOnly() throws InterruptedException {
        this.template.sendBody("seda:foo1", (Object)"blah");
        this.mock.expectedBodiesReceived(new Object[]{"test:blah"});
        this.mock.expectedHeaderReceived("CamelToEndpoint", (Object)"seda://foo1");
        this.template.sendBody("direct:enricher-test-1", (Object)"test");
        this.mock.assertIsSatisfied();
    }

    public void testPollEnrichInOnlyWaitWithTimeout() throws InterruptedException {
        this.mock.expectedBodiesReceived(new Object[]{"test:blah"});
        this.mock.expectedHeaderReceived("CamelToEndpoint", (Object)"seda://foo2");
        this.template.sendBody("direct:enricher-test-2", (Object)"test");
        this.mock.assertIsNotSatisfied();
        this.mock.reset();
        this.template.sendBody("seda:foo2", (Object)"blah");
        this.template.sendBody("direct:enricher-test-2", (Object)"test");
        this.mock.assertIsSatisfied();
    }

    public void testPollEnrichInOnlyWaitNoTimeout() throws InterruptedException {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                PollEnricherTest.this.template.sendBody("seda:foo3", (Object)"blah");
            }
        });
        long start = System.currentTimeMillis();
        this.mock.expectedBodiesReceived(new Object[]{"test:blah"});
        this.mock.expectedHeaderReceived("CamelToEndpoint", (Object)"seda://foo3");
        t.start();
        this.template.sendBody("direct:enricher-test-3", (Object)"test");
        this.mock.assertIsSatisfied();
        long delta = System.currentTimeMillis() - start;
        PollEnricherTest.assertTrue((String)("Should take approx 0.25 sec: was " + delta), (delta > 150L ? 1 : 0) != 0);
    }

    public void testPollEnrichInOut() throws InterruptedException {
        this.template.sendBody("seda:foo4", (Object)"blah");
        String result = (String)this.template.sendBody("direct:enricher-test-4", ExchangePattern.InOut, (Object)"test");
        PollEnricherTest.assertEquals((String)"test:blah", (String)result);
    }

    public void testPollEnrichInOutPlusHeader() throws InterruptedException {
        this.template.sendBody("seda:foo4", (Object)"blah");
        Exchange exchange = this.template.request("direct:enricher-test-4", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setHeader("foo", (Object)"bar");
                exchange.getIn().setBody((Object)"test");
            }
        });
        PollEnricherTest.assertEquals((Object)"bar", (Object)exchange.getIn().getHeader("foo"));
        PollEnricherTest.assertEquals((Object)"test:blah", (Object)exchange.getIn().getBody());
        PollEnricherTest.assertFalse((exchange.hasOut() && exchange.getOut().isFault() ? 1 : 0) != 0);
        PollEnricherTest.assertEquals((Object)"seda://foo4", (Object)exchange.getOut().getHeader("CamelToEndpoint"));
        PollEnricherTest.assertNull((Object)exchange.getException());
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:enricher-test-1").pollEnrich("seda:foo1", (AggregationStrategy)aggregationStrategy)).to("mock:mock");
                ((RouteDefinition)this.from("direct:enricher-test-2").pollEnrich("seda:foo2", 1000L, (AggregationStrategy)aggregationStrategy)).to("mock:mock");
                ((RouteDefinition)this.from("direct:enricher-test-3").pollEnrich("seda:foo3", -1L, (AggregationStrategy)aggregationStrategy)).to("mock:mock");
                this.from("direct:enricher-test-4").pollEnrich("seda:foo4", (AggregationStrategy)aggregationStrategy);
            }
        };
    }
}

