/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;

public class AdviceWithAutoStartupTest
extends ContextTestSupport {
    public void testAdvised() throws Exception {
        AdviceWithAutoStartupTest.assertFalse((boolean)this.context.getRouteStatus("foo").isStarted());
        AdviceWithAutoStartupTest.assertFalse((boolean)this.context.getRouteStatus("bar").isStarted());
        this.context.getRouteDefinition("bar").adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.replaceFromWith("seda:newBar");
            }
        });
        AdviceWithAutoStartupTest.assertFalse((boolean)this.context.getRouteStatus("foo").isStarted());
        AdviceWithAutoStartupTest.assertFalse((boolean)this.context.getRouteStatus("bar").isStarted());
        this.context.startRoute("foo");
        this.context.startRoute("bar");
        AdviceWithAutoStartupTest.assertTrue((boolean)this.context.getRouteStatus("foo").isStarted());
        AdviceWithAutoStartupTest.assertTrue((boolean)this.context.getRouteStatus("bar").isStarted());
        this.getMockEndpoint("mock:newBar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AdviceWithAutoStartupTest.this.context.setAutoStartup(Boolean.valueOf(false));
                this.from("direct:start").routeId("foo").to("seda:newBar");
                this.from("seda:bar").routeId("bar").to("mock:newBar");
            }
        };
    }
}

