/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.BreakpointSupport;
import org.apache.camel.impl.DefaultDebugger;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Debugger;

public class DebugSingleStepTest
extends ContextTestSupport {
    private List<String> logs = new ArrayList<String>();
    private Breakpoint breakpoint;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.breakpoint = new BreakpointSupport(){

            public void beforeProcess(Exchange exchange, Processor processor, ProcessorDefinition<?> definition) {
                String body = (String)exchange.getIn().getBody(String.class);
                DebugSingleStepTest.this.logs.add("Single stepping at " + definition.getLabel() + " with body: " + body);
            }
        };
    }

    public void testDebug() throws Exception {
        this.context.getDebugger().addSingleStepBreakpoint(this.breakpoint);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello Camel"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        DebugSingleStepTest.assertEquals((int)6, (int)this.logs.size());
        DebugSingleStepTest.assertEquals((String)"Single stepping at log:foo with body: Hello World", (String)this.logs.get(0));
        DebugSingleStepTest.assertEquals((String)"Single stepping at log:bar with body: Hello World", (String)this.logs.get(1));
        DebugSingleStepTest.assertEquals((String)"Single stepping at mock:result with body: Hello World", (String)this.logs.get(2));
        DebugSingleStepTest.assertEquals((String)"Single stepping at log:foo with body: Hello Camel", (String)this.logs.get(3));
        DebugSingleStepTest.assertEquals((String)"Single stepping at log:bar with body: Hello Camel", (String)this.logs.get(4));
        DebugSingleStepTest.assertEquals((String)"Single stepping at mock:result with body: Hello Camel", (String)this.logs.get(5));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                DebugSingleStepTest.this.context.setDebugger((Debugger)new DefaultDebugger());
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).to("log:bar")).to("mock:result");
            }
        };
    }
}

