/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.WhenDefinition;

public class TraceInitIdOnAllNodesTest
extends ContextTestSupport {
    public void testInitIdsOnAllNodes() throws Exception {
        this.getMockEndpoint("mock:camel").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:other").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:end").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        TraceInitIdOnAllNodesTest.assertNotNull((Object)route);
        ChoiceDefinition choice = (ChoiceDefinition)route.getOutputs().get(0);
        TraceInitIdOnAllNodesTest.assertEquals((String)"choice1", (String)choice.getId());
        WhenDefinition when = (WhenDefinition)choice.getOutputs().get(0);
        TraceInitIdOnAllNodesTest.assertEquals((String)"when1", (String)when.getId());
        LogDefinition log1 = (LogDefinition)when.getOutputs().get(0);
        TraceInitIdOnAllNodesTest.assertEquals((String)"log1", (String)log1.getId());
        ToDefinition to1 = (ToDefinition)when.getOutputs().get(1);
        TraceInitIdOnAllNodesTest.assertEquals((String)"camel", (String)to1.getId());
        OtherwiseDefinition other = (OtherwiseDefinition)choice.getOutputs().get(1);
        TraceInitIdOnAllNodesTest.assertEquals((String)"otherwise1", (String)other.getId());
        LogDefinition log2 = (LogDefinition)other.getOutputs().get(0);
        TraceInitIdOnAllNodesTest.assertEquals((String)"log2", (String)log2.getId());
        ToDefinition to2 = (ToDefinition)other.getOutputs().get(1);
        TraceInitIdOnAllNodesTest.assertEquals((String)"to1", (String)to2.getId());
        ToDefinition to3 = (ToDefinition)other.getOutputs().get(2);
        TraceInitIdOnAllNodesTest.assertEquals((String)"foo", (String)to3.getId());
        ToDefinition to4 = (ToDefinition)route.getOutputs().get(1);
        TraceInitIdOnAllNodesTest.assertEquals((String)"end", (String)to4.getId());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                TraceInitIdOnAllNodesTest.this.context.setTracing(Boolean.valueOf(true));
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().contains((Object)"Camel")).log("A Camel message")).to("mock:camel")).id("camel")).otherwise().log("Some other kind of message")).to("mock:other")).to("mock:foo")).id("foo")).end().to("mock:end").id("end");
            }
        };
    }
}

