/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.SplitDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DumpModelAsXmlSplitBodyRouteTest
extends ContextTestSupport {
    public void testDumpModelAsXml() throws Exception {
        String xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        DumpModelAsXmlSplitBodyRouteTest.assertNotNull((Object)xml);
        this.log.info(xml);
        Document doc = new XmlConverter().toDOMDocument(xml);
        NodeList nodes = doc.getElementsByTagName("simple");
        DumpModelAsXmlSplitBodyRouteTest.assertEquals((int)1, (int)nodes.getLength());
        Element node = (Element)nodes.item(0);
        DumpModelAsXmlSplitBodyRouteTest.assertNotNull((String)"Node <simple> expected to be instanceof Element", (Object)node);
        DumpModelAsXmlSplitBodyRouteTest.assertEquals((String)"body", (String)node.getTextContent());
        nodes = doc.getElementsByTagName("split");
        DumpModelAsXmlSplitBodyRouteTest.assertEquals((int)1, (int)nodes.getLength());
        nodes = doc.getElementsByTagName("to");
        DumpModelAsXmlSplitBodyRouteTest.assertEquals((int)1, (int)nodes.getLength());
        node = (Element)nodes.item(0);
        DumpModelAsXmlSplitBodyRouteTest.assertNotNull((String)"Node <to> expected to be instanceof Element", (Object)node);
        DumpModelAsXmlSplitBodyRouteTest.assertEquals((String)"mock:sub", (String)node.getAttribute("uri"));
        DumpModelAsXmlSplitBodyRouteTest.assertEquals((String)"myMock", (String)node.getAttribute("id"));
        DumpModelAsXmlSplitBodyRouteTest.assertEquals((String)"true", (String)node.getAttribute("customId"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((ExpressionNode)((SplitDefinition)this.from("direct:start").routeId("myRoute").split().body()).to("mock:sub")).id("myMock")).end();
            }
        };
    }
}

