/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.TypeConverter;
import org.apache.camel.util.AnotherExampleBean;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.OtherExampleBean;
import org.apache.camel.util.jndi.ExampleBean;

public class IntrospectionSupportTest
extends ContextTestSupport {
    public void testOverloadSetterChooseStringSetter() throws Exception {
        MyOverloadedBean overloadedBean = new MyOverloadedBean();
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)overloadedBean, (String)"bean", (Object)"James");
        IntrospectionSupportTest.assertEquals((String)"James", (String)overloadedBean.getName());
    }

    public void testOverloadSetterChooseBeanSetter() throws Exception {
        MyOverloadedBean overloadedBean = new MyOverloadedBean();
        ExampleBean bean = new ExampleBean();
        bean.setName("Claus");
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)overloadedBean, (String)"bean", (Object)bean);
        IntrospectionSupportTest.assertEquals((String)"Claus", (String)overloadedBean.getName());
    }

    public void testOverloadSetterChooseUsingTypeConverter() throws Exception {
        MyOverloadedBean overloadedBean = new MyOverloadedBean();
        byte[] value = "Willem".getBytes();
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)overloadedBean, (String)"bean", (Object)value);
        IntrospectionSupportTest.assertEquals((String)"Willem", (String)overloadedBean.getName());
    }

    public void testIsSetterBuilderPatternSupport() throws Exception {
        Method setter = MyBuilderBean.class.getMethod("setName", String.class);
        Method setter2 = MyOtherBuilderBean.class.getMethod("setName", String.class);
        Method setter3 = MyOtherOtherBuilderBean.class.getMethod("setName", String.class);
        IntrospectionSupportTest.assertFalse((boolean)IntrospectionSupport.isSetter((Method)setter, (boolean)false));
        IntrospectionSupportTest.assertTrue((boolean)IntrospectionSupport.isSetter((Method)setter, (boolean)true));
        IntrospectionSupportTest.assertFalse((boolean)IntrospectionSupport.isSetter((Method)setter2, (boolean)false));
        IntrospectionSupportTest.assertTrue((boolean)IntrospectionSupport.isSetter((Method)setter2, (boolean)true));
        IntrospectionSupportTest.assertFalse((boolean)IntrospectionSupport.isSetter((Method)setter3, (boolean)false));
        IntrospectionSupportTest.assertTrue((boolean)IntrospectionSupport.isSetter((Method)setter3, (boolean)true));
    }

    public void testHasProperties() throws Exception {
        Map empty = Collections.emptyMap();
        IntrospectionSupportTest.assertFalse((boolean)IntrospectionSupport.hasProperties(empty, null));
        IntrospectionSupportTest.assertFalse((boolean)IntrospectionSupport.hasProperties(empty, (String)""));
        IntrospectionSupportTest.assertFalse((boolean)IntrospectionSupport.hasProperties(empty, (String)"foo."));
        HashMap<String, String> param = new HashMap<String, String>();
        IntrospectionSupportTest.assertFalse((boolean)IntrospectionSupport.hasProperties(param, null));
        IntrospectionSupportTest.assertFalse((boolean)IntrospectionSupport.hasProperties(param, (String)""));
        IntrospectionSupportTest.assertFalse((boolean)IntrospectionSupport.hasProperties(param, (String)"foo."));
        param.put("name", "Claus");
        IntrospectionSupportTest.assertTrue((boolean)IntrospectionSupport.hasProperties(param, null));
        IntrospectionSupportTest.assertTrue((boolean)IntrospectionSupport.hasProperties(param, (String)""));
        IntrospectionSupportTest.assertFalse((boolean)IntrospectionSupport.hasProperties(param, (String)"foo."));
        param.put("foo.name", "Hadrian");
        IntrospectionSupportTest.assertTrue((boolean)IntrospectionSupport.hasProperties(param, null));
        IntrospectionSupportTest.assertTrue((boolean)IntrospectionSupport.hasProperties(param, (String)""));
        IntrospectionSupportTest.assertTrue((boolean)IntrospectionSupport.hasProperties(param, (String)"foo."));
    }

    public void testGetProperties() throws Exception {
        ExampleBean bean = new ExampleBean();
        bean.setName("Claus");
        bean.setPrice(10.0);
        HashMap map = new HashMap();
        IntrospectionSupport.getProperties((Object)bean, map, null);
        IntrospectionSupportTest.assertEquals((int)3, (int)map.size());
        IntrospectionSupportTest.assertEquals((Object)"Claus", map.get("name"));
        String price = map.get("price").toString();
        IntrospectionSupportTest.assertTrue((boolean)price.startsWith("10"));
        IntrospectionSupportTest.assertEquals(null, map.get("id"));
    }

    public void testAnotherGetProperties() throws Exception {
        AnotherExampleBean bean = new AnotherExampleBean();
        bean.setId("123");
        bean.setName("Claus");
        bean.setPrice(10.0);
        Date date = new Date(0L);
        bean.setDate(date);
        bean.setGoldCustomer(true);
        bean.setLittle(true);
        ArrayList children = new ArrayList();
        bean.setChildren(children);
        HashMap map = new HashMap();
        IntrospectionSupport.getProperties((Object)bean, map, null);
        IntrospectionSupportTest.assertEquals((int)7, (int)map.size());
        IntrospectionSupportTest.assertEquals((Object)"Claus", map.get("name"));
        String price = map.get("price").toString();
        IntrospectionSupportTest.assertTrue((boolean)price.startsWith("10"));
        IntrospectionSupportTest.assertSame((Object)date, map.get("date"));
        IntrospectionSupportTest.assertSame(children, map.get("children"));
        IntrospectionSupportTest.assertEquals((Object)Boolean.TRUE, map.get("goldCustomer"));
        IntrospectionSupportTest.assertEquals((Object)Boolean.TRUE, map.get("little"));
        IntrospectionSupportTest.assertEquals((Object)"123", map.get("id"));
    }

    public void testGetPropertiesOptionPrefix() throws Exception {
        ExampleBean bean = new ExampleBean();
        bean.setName("Claus");
        bean.setPrice(10.0);
        bean.setId("123");
        HashMap map = new HashMap();
        IntrospectionSupport.getProperties((Object)bean, map, (String)"bean.");
        IntrospectionSupportTest.assertEquals((int)3, (int)map.size());
        IntrospectionSupportTest.assertEquals((Object)"Claus", map.get("bean.name"));
        String price = map.get("bean.price").toString();
        IntrospectionSupportTest.assertTrue((boolean)price.startsWith("10"));
        IntrospectionSupportTest.assertEquals((Object)"123", map.get("bean.id"));
    }

    public void testGetPropertiesSkipNull() throws Exception {
        ExampleBean bean = new ExampleBean();
        bean.setName("Claus");
        bean.setPrice(10.0);
        bean.setId(null);
        HashMap map = new HashMap();
        IntrospectionSupport.getProperties((Object)bean, map, null, (boolean)false);
        IntrospectionSupportTest.assertEquals((int)2, (int)map.size());
        IntrospectionSupportTest.assertEquals((Object)"Claus", map.get("name"));
        String price = map.get("price").toString();
        IntrospectionSupportTest.assertTrue((boolean)price.startsWith("10"));
    }

    public void testGetProperty() throws Exception {
        ExampleBean bean = new ExampleBean();
        bean.setId("123");
        bean.setName("Claus");
        bean.setPrice(10.0);
        Object name = IntrospectionSupport.getProperty((Object)bean, (String)"name");
        IntrospectionSupportTest.assertEquals((Object)"Claus", (Object)name);
    }

    public void testSetProperty() throws Exception {
        ExampleBean bean = new ExampleBean();
        bean.setId("123");
        bean.setName("Claus");
        bean.setPrice(10.0);
        IntrospectionSupport.setProperty((Object)bean, (String)"name", (Object)"James");
        IntrospectionSupportTest.assertEquals((String)"James", (String)bean.getName());
    }

    public void testAnotherGetProperty() throws Exception {
        AnotherExampleBean bean = new AnotherExampleBean();
        bean.setName("Claus");
        bean.setPrice(10.0);
        Date date = new Date(0L);
        bean.setDate(date);
        bean.setGoldCustomer(true);
        bean.setLittle(true);
        ArrayList children = new ArrayList();
        bean.setChildren(children);
        Object name = IntrospectionSupport.getProperty((Object)bean, (String)"name");
        IntrospectionSupportTest.assertEquals((Object)"Claus", (Object)name);
        IntrospectionSupportTest.assertSame((Object)date, (Object)IntrospectionSupport.getProperty((Object)bean, (String)"date"));
        IntrospectionSupportTest.assertSame(children, (Object)IntrospectionSupport.getProperty((Object)bean, (String)"children"));
        IntrospectionSupportTest.assertEquals((Object)Boolean.TRUE, (Object)IntrospectionSupport.getProperty((Object)bean, (String)"goldCustomer"));
        IntrospectionSupportTest.assertEquals((Object)Boolean.TRUE, (Object)IntrospectionSupport.getProperty((Object)bean, (String)"little"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetPropertyLocaleIndependent() throws Exception {
        Locale oldLocale = Locale.getDefault();
        Locale.setDefault(new Locale("tr", "TR"));
        try {
            ExampleBean bean = new ExampleBean();
            bean.setName("Claus");
            bean.setPrice(10.0);
            bean.setId("1");
            Object name = IntrospectionSupport.getProperty((Object)bean, (String)"name");
            Object id = IntrospectionSupport.getProperty((Object)bean, (String)"id");
            Object price = IntrospectionSupport.getProperty((Object)bean, (String)"price");
            IntrospectionSupportTest.assertEquals((Object)"Claus", (Object)name);
            IntrospectionSupportTest.assertEquals((Object)10.0, (Object)price);
            IntrospectionSupportTest.assertEquals((Object)"1", (Object)id);
        }
        finally {
            Locale.setDefault(oldLocale);
        }
    }

    public void testGetPropertyGetter() throws Exception {
        ExampleBean bean = new ExampleBean();
        bean.setName("Claus");
        bean.setPrice(10.0);
        Method name = IntrospectionSupport.getPropertyGetter(ExampleBean.class, (String)"name");
        IntrospectionSupportTest.assertEquals((String)"getName", (String)name.getName());
        try {
            IntrospectionSupport.getPropertyGetter(ExampleBean.class, (String)"xxx");
            IntrospectionSupportTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchMethodException e) {
            IntrospectionSupportTest.assertEquals((String)"org.apache.camel.util.jndi.ExampleBean.getXxx()", (String)e.getMessage());
        }
    }

    public void testGetPropertySetter() throws Exception {
        ExampleBean bean = new ExampleBean();
        bean.setName("Claus");
        bean.setPrice(10.0);
        Method name = IntrospectionSupport.getPropertySetter(ExampleBean.class, (String)"name");
        IntrospectionSupportTest.assertEquals((String)"setName", (String)name.getName());
        try {
            IntrospectionSupport.getPropertySetter(ExampleBean.class, (String)"xxx");
            IntrospectionSupportTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchMethodException e) {
            IntrospectionSupportTest.assertEquals((String)"org.apache.camel.util.jndi.ExampleBean.setXxx", (String)e.getMessage());
        }
    }

    public void testIsGetter() throws Exception {
        ExampleBean bean = new ExampleBean();
        Method name = bean.getClass().getMethod("getName", null);
        IntrospectionSupportTest.assertEquals((boolean)true, (boolean)IntrospectionSupport.isGetter((Method)name));
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isSetter((Method)name));
        Method price = bean.getClass().getMethod("getPrice", null);
        IntrospectionSupportTest.assertEquals((boolean)true, (boolean)IntrospectionSupport.isGetter((Method)price));
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isSetter((Method)price));
    }

    public void testIsSetter() throws Exception {
        ExampleBean bean = new ExampleBean();
        Method name = bean.getClass().getMethod("setName", String.class);
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isGetter((Method)name));
        IntrospectionSupportTest.assertEquals((boolean)true, (boolean)IntrospectionSupport.isSetter((Method)name));
        Method price = bean.getClass().getMethod("setPrice", Double.TYPE);
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isGetter((Method)price));
        IntrospectionSupportTest.assertEquals((boolean)true, (boolean)IntrospectionSupport.isSetter((Method)price));
    }

    public void testOtherIsGetter() throws Exception {
        OtherExampleBean bean = new OtherExampleBean();
        Method customerId = bean.getClass().getMethod("getCustomerId", null);
        IntrospectionSupportTest.assertEquals((boolean)true, (boolean)IntrospectionSupport.isGetter((Method)customerId));
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isSetter((Method)customerId));
        Method goldCustomer = bean.getClass().getMethod("isGoldCustomer", null);
        IntrospectionSupportTest.assertEquals((boolean)true, (boolean)IntrospectionSupport.isGetter((Method)goldCustomer));
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isSetter((Method)goldCustomer));
        Method silverCustomer = bean.getClass().getMethod("isSilverCustomer", null);
        IntrospectionSupportTest.assertEquals((boolean)true, (boolean)IntrospectionSupport.isGetter((Method)silverCustomer));
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isSetter((Method)silverCustomer));
        Method company = bean.getClass().getMethod("getCompany", null);
        IntrospectionSupportTest.assertEquals((boolean)true, (boolean)IntrospectionSupport.isGetter((Method)company));
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isSetter((Method)company));
        Method setupSomething = bean.getClass().getMethod("setupSomething", Object.class);
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isGetter((Method)setupSomething));
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isSetter((Method)setupSomething));
    }

    public void testOtherIsSetter() throws Exception {
        OtherExampleBean bean = new OtherExampleBean();
        Method customerId = bean.getClass().getMethod("setCustomerId", Integer.TYPE);
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isGetter((Method)customerId));
        IntrospectionSupportTest.assertEquals((boolean)true, (boolean)IntrospectionSupport.isSetter((Method)customerId));
        Method goldCustomer = bean.getClass().getMethod("setGoldCustomer", Boolean.TYPE);
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isGetter((Method)goldCustomer));
        IntrospectionSupportTest.assertEquals((boolean)true, (boolean)IntrospectionSupport.isSetter((Method)goldCustomer));
        Method silverCustomer = bean.getClass().getMethod("setSilverCustomer", Boolean.class);
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isGetter((Method)silverCustomer));
        IntrospectionSupportTest.assertEquals((boolean)true, (boolean)IntrospectionSupport.isSetter((Method)silverCustomer));
        Method company = bean.getClass().getMethod("setCompany", String.class);
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isGetter((Method)company));
        IntrospectionSupportTest.assertEquals((boolean)true, (boolean)IntrospectionSupport.isSetter((Method)company));
        Method setupSomething = bean.getClass().getMethod("setupSomething", Object.class);
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isGetter((Method)setupSomething));
        IntrospectionSupportTest.assertEquals((boolean)false, (boolean)IntrospectionSupport.isSetter((Method)setupSomething));
    }

    public void testExtractProperties() throws Exception {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("foo.name", "Camel");
        params.put("foo.age", 5);
        params.put("bar", "yes");
        Map foo = IntrospectionSupport.extractProperties(params, (String)"foo.");
        IntrospectionSupportTest.assertEquals((int)2, (int)foo.size());
        IntrospectionSupportTest.assertEquals((Object)"Camel", foo.get("name"));
        IntrospectionSupportTest.assertEquals((Object)5, foo.get("age"));
        IntrospectionSupportTest.assertEquals((int)1, (int)params.size());
        IntrospectionSupportTest.assertEquals((Object)"yes", params.get("bar"));
    }

    public void testFindSetterMethodsOrderedByParameterType() throws Exception {
        List setters = IntrospectionSupport.findSetterMethodsOrderedByParameterType(MyOverloadedBean.class, (String)"bean", (boolean)false);
        IntrospectionSupportTest.assertNotNull((Object)setters);
        IntrospectionSupportTest.assertEquals((int)2, (int)setters.size());
        IntrospectionSupportTest.assertEquals(ExampleBean.class, ((Method)setters.get(0)).getParameterTypes()[0]);
        IntrospectionSupportTest.assertEquals(String.class, ((Method)setters.get(1)).getParameterTypes()[0]);
    }

    public class MyOtherOtherBuilderBean
    extends MyOtherBuilderBean {
        @Override
        public MyOtherOtherBuilderBean setName(String name) {
            super.setName(name);
            return this;
        }
    }

    public class MyOtherBuilderBean
    extends MyBuilderBean {
    }

    public class MyBuilderBean {
        private String name;

        public String getName() {
            return this.name;
        }

        public MyBuilderBean setName(String name) {
            this.name = name;
            return this;
        }
    }

    public class MyOverloadedBean {
        private ExampleBean bean;

        public void setBean(ExampleBean bean) {
            this.bean = bean;
        }

        public void setBean(String name) {
            this.bean = new ExampleBean();
            this.bean.setName(name);
        }

        public String getName() {
            return this.bean.getName();
        }
    }
}

