/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.camel.TestSupport;
import org.apache.camel.util.LRUSoftCache;

public class LRUSoftCacheTest
extends TestSupport {
    public void testLRUSoftCacheGetAndPut() throws Exception {
        LRUSoftCache cache = new LRUSoftCache(1000);
        cache.put((Object)1, (Object)"foo");
        cache.put((Object)2, (Object)"bar");
        LRUSoftCacheTest.assertEquals((Object)"foo", (Object)cache.get((Object)1));
        LRUSoftCacheTest.assertEquals((Object)"bar", (Object)cache.get((Object)2));
        LRUSoftCacheTest.assertEquals(null, (Object)cache.get((Object)3));
        LRUSoftCacheTest.assertEquals((int)2, (int)cache.size());
    }

    public void testLRUSoftCacheHitsAndMisses() throws Exception {
        LRUSoftCache cache = new LRUSoftCache(1000);
        cache.put((Object)1, (Object)"foo");
        cache.put((Object)2, (Object)"bar");
        LRUSoftCacheTest.assertEquals((long)0L, (long)cache.getHits());
        LRUSoftCacheTest.assertEquals((long)0L, (long)cache.getMisses());
        cache.get((Object)1);
        LRUSoftCacheTest.assertEquals((long)1L, (long)cache.getHits());
        LRUSoftCacheTest.assertEquals((long)0L, (long)cache.getMisses());
        cache.get((Object)3);
        LRUSoftCacheTest.assertEquals((long)1L, (long)cache.getHits());
        LRUSoftCacheTest.assertEquals((long)1L, (long)cache.getMisses());
        cache.get((Object)2);
        LRUSoftCacheTest.assertEquals((long)2L, (long)cache.getHits());
        LRUSoftCacheTest.assertEquals((long)1L, (long)cache.getMisses());
    }

    public void testLRUSoftCachePutOverride() throws Exception {
        LRUSoftCache cache = new LRUSoftCache(1000);
        Object old = cache.put((Object)1, (Object)"foo");
        LRUSoftCacheTest.assertNull((Object)old);
        old = cache.put((Object)2, (Object)"bar");
        LRUSoftCacheTest.assertNull((Object)old);
        LRUSoftCacheTest.assertEquals((Object)"foo", (Object)cache.get((Object)1));
        LRUSoftCacheTest.assertEquals((Object)"bar", (Object)cache.get((Object)2));
        old = cache.put((Object)1, (Object)"changed");
        LRUSoftCacheTest.assertEquals((Object)"foo", (Object)old);
        LRUSoftCacheTest.assertEquals((Object)"changed", (Object)cache.get((Object)1));
        LRUSoftCacheTest.assertEquals((int)2, (int)cache.size());
    }

    public void testLRUSoftCachePutAll() throws Exception {
        LRUSoftCache cache = new LRUSoftCache(1000);
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "foo");
        map.put(2, "bar");
        cache.putAll(map);
        LRUSoftCacheTest.assertEquals((Object)"foo", (Object)cache.get((Object)1));
        LRUSoftCacheTest.assertEquals((Object)"bar", (Object)cache.get((Object)2));
        LRUSoftCacheTest.assertEquals(null, (Object)cache.get((Object)3));
        LRUSoftCacheTest.assertEquals((int)2, (int)cache.size());
    }

    public void testLRUSoftCachePutAllAnotherLRUSoftCache() throws Exception {
        LRUSoftCache cache = new LRUSoftCache(1000);
        LRUSoftCache cache2 = new LRUSoftCache(1000);
        cache2.put((Object)1, (Object)"foo");
        cache2.put((Object)2, (Object)"bar");
        cache.putAll((Map)cache2);
        LRUSoftCacheTest.assertEquals((Object)"foo", (Object)cache.get((Object)1));
        LRUSoftCacheTest.assertEquals((Object)"bar", (Object)cache.get((Object)2));
        LRUSoftCacheTest.assertEquals(null, (Object)cache.get((Object)3));
        LRUSoftCacheTest.assertEquals((int)2, (int)cache.size());
    }

    public void testLRUSoftCacheRemove() throws Exception {
        LRUSoftCache cache = new LRUSoftCache(1000);
        cache.put((Object)1, (Object)"foo");
        cache.put((Object)2, (Object)"bar");
        LRUSoftCacheTest.assertEquals((Object)"bar", (Object)cache.get((Object)2));
        cache.remove((Object)2);
        LRUSoftCacheTest.assertEquals(null, (Object)cache.get((Object)2));
    }

    public void testLRUSoftCacheValues() throws Exception {
        LRUSoftCache cache = new LRUSoftCache(1000);
        cache.put((Object)1, (Object)"foo");
        cache.put((Object)2, (Object)"bar");
        Collection col = cache.values();
        LRUSoftCacheTest.assertEquals((int)2, (int)col.size());
        Iterator it = col.iterator();
        LRUSoftCacheTest.assertEquals((Object)"foo", it.next());
        LRUSoftCacheTest.assertEquals((Object)"bar", it.next());
    }

    public void testLRUSoftCacheEmpty() throws Exception {
        LRUSoftCache cache = new LRUSoftCache(1000);
        LRUSoftCacheTest.assertTrue((boolean)cache.isEmpty());
        cache.put((Object)1, (Object)"foo");
        LRUSoftCacheTest.assertFalse((boolean)cache.isEmpty());
        cache.put((Object)2, (Object)"bar");
        LRUSoftCacheTest.assertFalse((boolean)cache.isEmpty());
        cache.remove((Object)2);
        LRUSoftCacheTest.assertFalse((boolean)cache.isEmpty());
        cache.clear();
        LRUSoftCacheTest.assertTrue((boolean)cache.isEmpty());
    }

    public void testLRUSoftCacheContainsKey() throws Exception {
        LRUSoftCache cache = new LRUSoftCache(1000);
        LRUSoftCacheTest.assertFalse((boolean)cache.containsKey((Object)1));
        cache.put((Object)1, (Object)"foo");
        LRUSoftCacheTest.assertTrue((boolean)cache.containsKey((Object)1));
        LRUSoftCacheTest.assertFalse((boolean)cache.containsKey((Object)2));
        cache.put((Object)2, (Object)"foo");
        LRUSoftCacheTest.assertTrue((boolean)cache.containsKey((Object)2));
        cache.clear();
        LRUSoftCacheTest.assertFalse((boolean)cache.containsKey((Object)1));
        LRUSoftCacheTest.assertFalse((boolean)cache.containsKey((Object)2));
    }

    public void testLRUSoftCacheKeySet() throws Exception {
        LRUSoftCache cache = new LRUSoftCache(1000);
        cache.put((Object)1, (Object)"foo");
        cache.put((Object)2, (Object)"foo");
        Set keys = cache.keySet();
        LRUSoftCacheTest.assertEquals((int)2, (int)keys.size());
        Iterator it = keys.iterator();
        LRUSoftCacheTest.assertEquals((int)1, (int)((Integer)it.next()));
        LRUSoftCacheTest.assertEquals((int)2, (int)((Integer)it.next()));
    }
}

